/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.packet.type.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.api.quantumtunnel.TunnelFrequencyBuffer;
import nuclearscience.common.packet.NetworkHandler;
import nuclearscience.common.packet.type.client.ClientBarrierMethods;

public class PacketSetClientTunnelFrequencies
implements CustomPacketPayload {
    public static final ResourceLocation PACKET_SETCLIENTRADIOACTIVEGASES_PACKETID = NetworkHandler.id("packetsetclienttunnelfrequencies");
    public static final CustomPacketPayload.Type<PacketSetClientTunnelFrequencies> TYPE = new CustomPacketPayload.Type(PACKET_SETCLIENTRADIOACTIVEGASES_PACKETID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSetClientTunnelFrequencies> CODEC = new StreamCodec<RegistryFriendlyByteBuf, PacketSetClientTunnelFrequencies>(){

        public PacketSetClientTunnelFrequencies decode(RegistryFriendlyByteBuf buf) {
            HashMap<UUID, HashSet<TunnelFrequency>> data = new HashMap<UUID, HashSet<TunnelFrequency>>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                UUID id = (UUID)UUIDUtil.STREAM_CODEC.decode((Object)buf);
                HashSet<TunnelFrequency> set = new HashSet<TunnelFrequency>();
                int setSize = buf.readInt();
                for (int j = 0; j < setSize; ++j) {
                    set.add((TunnelFrequency)TunnelFrequency.STREAM_CODEC.decode((Object)buf));
                }
                data.put(id, set);
            }
            return new PacketSetClientTunnelFrequencies(data, (TunnelFrequencyBuffer)TunnelFrequencyBuffer.STREAM_CODEC.decode((Object)buf), (BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf));
        }

        public void encode(RegistryFriendlyByteBuf buf, PacketSetClientTunnelFrequencies packet) {
            buf.writeInt(packet.frequencies.size());
            for (Map.Entry<UUID, HashSet<TunnelFrequency>> entry : packet.frequencies.entrySet()) {
                UUIDUtil.STREAM_CODEC.encode((Object)buf, (Object)entry.getKey());
                buf.writeInt(entry.getValue().size());
                for (TunnelFrequency freq : entry.getValue()) {
                    TunnelFrequency.STREAM_CODEC.encode((Object)buf, (Object)freq);
                }
            }
            TunnelFrequencyBuffer.STREAM_CODEC.encode((Object)buf, (Object)packet.currBuffer);
            BlockPos.STREAM_CODEC.encode((Object)buf, (Object)packet.tilePos);
        }
    };
    private final HashMap<UUID, HashSet<TunnelFrequency>> frequencies;
    private final TunnelFrequencyBuffer currBuffer;
    private final BlockPos tilePos;

    public PacketSetClientTunnelFrequencies(HashMap<UUID, HashSet<TunnelFrequency>> frequencies, TunnelFrequencyBuffer currBuffer, BlockPos tilePos) {
        this.frequencies = frequencies;
        this.currBuffer = currBuffer;
        this.tilePos = tilePos;
    }

    public static void handle(PacketSetClientTunnelFrequencies message, IPayloadContext context) {
        ClientBarrierMethods.handleSetClientTunnelFrequencies(message.frequencies, message.currBuffer, message.tilePos);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

