/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.packet.type.server;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.common.packet.NetworkHandler;
import nuclearscience.common.packet.type.server.ServerBarrierMethods;

public class PacketDeleteFrequency
implements CustomPacketPayload {
    public static final ResourceLocation PACKET_DELETEFREQUENCY_PACKETID = NetworkHandler.id("packetdeletefrequency");
    public static final CustomPacketPayload.Type<PacketDeleteFrequency> TYPE = new CustomPacketPayload.Type(PACKET_DELETEFREQUENCY_PACKETID);
    public static final StreamCodec<ByteBuf, PacketDeleteFrequency> CODEC = new StreamCodec<ByteBuf, PacketDeleteFrequency>(){

        public PacketDeleteFrequency decode(ByteBuf buf) {
            return new PacketDeleteFrequency((UUID)UUIDUtil.STREAM_CODEC.decode((Object)buf), (TunnelFrequency)TunnelFrequency.STREAM_CODEC.decode((Object)buf));
        }

        public void encode(ByteBuf buf, PacketDeleteFrequency packet) {
            UUIDUtil.STREAM_CODEC.encode((Object)buf, (Object)packet.requester);
            TunnelFrequency.STREAM_CODEC.encode((Object)buf, (Object)packet.frequency);
        }
    };
    private final UUID requester;
    private final TunnelFrequency frequency;

    public PacketDeleteFrequency(UUID requester, TunnelFrequency frequency) {
        this.requester = requester;
        this.frequency = frequency;
    }

    public static void handle(PacketDeleteFrequency message, IPayloadContext context) {
        ServerBarrierMethods.deleteFrequency(message.requester, message.frequency);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

