/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.packet.type.server;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.common.packet.NetworkHandler;
import nuclearscience.common.packet.type.server.ServerBarrierMethods;

public class PacketEditFrequency
implements CustomPacketPayload {
    public static final ResourceLocation PACKET_EDITFREQUENCY_PACKETID = NetworkHandler.id("packeteditfrequency");
    public static final CustomPacketPayload.Type<PacketEditFrequency> TYPE = new CustomPacketPayload.Type(PACKET_EDITFREQUENCY_PACKETID);
    public static final StreamCodec<ByteBuf, PacketEditFrequency> CODEC = new StreamCodec<ByteBuf, PacketEditFrequency>(){

        public PacketEditFrequency decode(ByteBuf buf) {
            return new PacketEditFrequency((UUID)UUIDUtil.STREAM_CODEC.decode((Object)buf), (TunnelFrequency)TunnelFrequency.STREAM_CODEC.decode((Object)buf));
        }

        public void encode(ByteBuf buf, PacketEditFrequency packet) {
            UUIDUtil.STREAM_CODEC.encode((Object)buf, (Object)packet.requester);
            TunnelFrequency.STREAM_CODEC.encode((Object)buf, (Object)packet.frequency);
        }
    };
    private final UUID requester;
    private final TunnelFrequency frequency;

    public PacketEditFrequency(UUID requester, TunnelFrequency frequency) {
        this.requester = requester;
        this.frequency = frequency;
    }

    public static void handle(PacketEditFrequency message, IPayloadContext context) {
        ServerBarrierMethods.editFrequency(message.requester, message.frequency);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

