/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.reloadlistener;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import nuclearscience.common.packet.type.client.PacketSetClientAtomicAssemblerWhitelistVals;
import org.apache.logging.log4j.Logger;
import voltaic.Voltaic;

public class AtomicAssemblerWhitelistRegister
extends SimplePreparableReloadListener<JsonObject> {
    public static AtomicAssemblerWhitelistRegister INSTANCE = null;
    public static final String KEY = "values";
    public static final String FOLDER = "machines";
    public static final String FILE_NAME = "atomic_assembler_whitelist";
    protected static final String JSON_EXTENSION = ".json";
    protected static final int JSON_EXTENSION_LENGTH = ".json".length();
    private static final Gson GSON = new Gson();
    private final HashSet<Item> whitelistedItems = new HashSet();
    private final HashSet<TagKey<Item>> tags = new HashSet();
    private final Logger logger = Voltaic.LOGGER;

    protected JsonObject prepare(ResourceManager manager, ProfilerFiller profiler) {
        JsonObject blacklistedItems = new JsonObject();
        ArrayList resources = new ArrayList(manager.listResources(FOLDER, AtomicAssemblerWhitelistRegister::isJson).entrySet());
        Collections.reverse(resources);
        JsonArray combinedArray = new JsonArray();
        for (Map.Entry entry : resources) {
            ResourceLocation loc = (ResourceLocation)entry.getKey();
            String namespace = loc.getNamespace();
            String filePath = loc.getPath();
            String dataPath = filePath.substring(FOLDER.length() + 1, filePath.length() - JSON_EXTENSION_LENGTH);
            ResourceLocation jsonFile = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)dataPath);
            Resource resource = (Resource)entry.getValue();
            try {
                InputStream inputStream = resource.open();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    JsonObject json = (JsonObject)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
                    combinedArray.addAll(json.get(KEY).getAsJsonArray());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException | RuntimeException exception) {
                this.logger.error("Data loader for {} could not read data {} from file {} in data pack {}", (Object)FOLDER, (Object)jsonFile, (Object)loc, (Object)resource.sourcePackId(), (Object)exception);
            }
        }
        blacklistedItems.add(KEY, (JsonElement)combinedArray);
        return blacklistedItems;
    }

    protected void apply(JsonObject json, ResourceManager manager, ProfilerFiller profiler) {
        this.whitelistedItems.clear();
        this.tags.clear();
        ArrayList list = (ArrayList)GSON.fromJson((JsonElement)json.get(KEY).getAsJsonArray(), ArrayList.class);
        list.forEach(key -> {
            if (key.charAt(0) == '#') {
                this.tags.add((TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)key.substring(1))));
            } else {
                this.whitelistedItems.add((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)key)));
            }
        });
    }

    public void generateTagValues() {
        this.tags.forEach(tag -> {
            for (ItemStack item : Ingredient.of((TagKey)tag).getItems()) {
                this.whitelistedItems.add(item.getItem());
            }
        });
        this.tags.clear();
    }

    public void setClientValues(HashSet<Item> fuels) {
        this.whitelistedItems.clear();
        this.whitelistedItems.addAll(fuels);
    }

    public AtomicAssemblerWhitelistRegister subscribeAsSyncable() {
        NeoForge.EVENT_BUS.addListener(this.getDatapackSyncListener());
        return this;
    }

    public HashSet<Item> getWhitelist() {
        return this.whitelistedItems;
    }

    public boolean isWhitelist(Item item) {
        return this.whitelistedItems.contains(item);
    }

    private Consumer<OnDatapackSyncEvent> getDatapackSyncListener() {
        return event -> {
            this.generateTagValues();
            ServerPlayer player = event.getPlayer();
            PacketSetClientAtomicAssemblerWhitelistVals packet = new PacketSetClientAtomicAssemblerWhitelistVals(this.whitelistedItems);
            if (player == null) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        };
    }

    private static boolean isJson(ResourceLocation filename) {
        return filename.getPath().contains("atomic_assembler_whitelist.json");
    }
}

