/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.settings;

import net.neoforged.neoforge.common.ModConfigSpec;

public class NuclearConfig {
    public static NuclearConfig INSTANCE;
    public ModConfigSpec SPEC;
    public ModConfigSpec.DoubleValue TRANSFORMER_EFFICIENCY;
    public ModConfigSpec.DoubleValue TELEPORTER_USAGE_PER_TELEPORT;
    public ModConfigSpec.DoubleValue RADIOISOTOPEGENERATOR_VOLTAGE;
    public ModConfigSpec.DoubleValue RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER;
    public ModConfigSpec.DoubleValue FISSIONREACTOR_MAXENERGYTARGET;
    public ModConfigSpec.DoubleValue MSRREACTOR_MAXENERGYTARGET;
    public ModConfigSpec.DoubleValue FUSIONREACTOR_MAXENERGYTARGET;
    public ModConfigSpec.DoubleValue FUSIONREACTOR_USAGE_PER_TICK;
    public ModConfigSpec.DoubleValue PARTICLEINJECTOR_USAGE_PER_PARTICLE;
    public ModConfigSpec.IntValue FUSIONREACTOR_MAXSTORAGE;
    public ModConfigSpec.DoubleValue GASCENTRIFUGE_USAGE_PER_TICK;
    public ModConfigSpec.IntValue GASCENTRIFUGE_REQUIRED_TICKS_PER_PROCESSING;
    public ModConfigSpec.DoubleValue FREEZEPLUG_USAGE_PER_TICK;
    public ModConfigSpec.DoubleValue MOLTENSALTSUPPLIER_VOLTAGE;
    public ModConfigSpec.DoubleValue MOLTENSALTSUPPLIER_USAGE_PER_TICK;
    public ModConfigSpec.DoubleValue ATOMICASSEMBLER_USAGE_PER_TICK;
    public ModConfigSpec.DoubleValue ATOMICASSEMBLER_VOLTAGE;
    public ModConfigSpec.IntValue ATOMICASSEMBLER_REQUIRED_TICKS;
    public ModConfigSpec.IntValue QUANTUM_TUNNEL_FREQUENCY_CAP_PER_PLAYER;
    public ModConfigSpec.IntValue ANTIMATTER_TICKS_ON_GROUND;
    public ModConfigSpec.DoubleValue CLOUD_CHAMBER_ENERGY_USAGE_PER_TICK;
    public ModConfigSpec.IntValue CLOUD_CHAMBER_FLUID_USAGE_PER_TICK;
    public ModConfigSpec.DoubleValue FALLOUT_SCRUBBER_USAGE_PER_TICK;
    public ModConfigSpec.IntValue ATOMIC_ASSEMBLER_RADIATION_RADIUS;
    public ModConfigSpec.IntValue CHEMICAL_EXTRACTOR_RADIATION_RADIUS;
    public ModConfigSpec.IntValue FUEL_REPROCESSOR_RADIATION_RADIUS;
    public ModConfigSpec.IntValue GAS_CENTRIFUGE_RADIATION_RADIUS;
    public ModConfigSpec.IntValue NUCLEAR_BOILER_RADIATION_RADIUS;
    public ModConfigSpec.IntValue PARTICLE_INJECTOR_RADIATION_RADIUS;
    public ModConfigSpec.IntValue RADIOACTIVE_PROCESSOR_RADIATION_RADIUS;
    public ModConfigSpec.IntValue RADIO_GENATOR_RADIATION_RADIUS;
    public ModConfigSpec.IntValue MOLTEN_SAL_SUPPLIER_RADIATION_RADIUS;
    public ModConfigSpec.IntValue DEFAULT_PARTICLE_COOLDOWN_TICKS;
    public ModConfigSpec.IntValue PARTICLE_SURVIVAL_TICKS;

    public NuclearConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("common");
        this.TELEPORTER_USAGE_PER_TELEPORT = builder.defineInRange("teleporter_usage", 1000000.0, 0.0, Double.MAX_VALUE);
        this.RADIOISOTOPEGENERATOR_VOLTAGE = builder.defineInRange("radioisotopegenerator_voltage", 120.0, 0.0, Double.MAX_VALUE);
        this.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER = builder.defineInRange("radioisotopegenerator_output_multiplier", (double)0.35f, 0.0, Double.MAX_VALUE);
        this.FISSIONREACTOR_MAXENERGYTARGET = builder.defineInRange("fissionreactor_max_energy_target", 350000.0, 0.0, Double.MAX_VALUE);
        this.MSRREACTOR_MAXENERGYTARGET = builder.defineInRange("msrreactor_max_energy_target", 850000.0, 0.0, Double.MAX_VALUE);
        this.FUSIONREACTOR_MAXENERGYTARGET = builder.defineInRange("fusionreactor_max_energy_target", 6000000.0, 0.0, Double.MAX_VALUE);
        this.FUSIONREACTOR_USAGE_PER_TICK = builder.defineInRange("fusionreactor_usage_per_tick", 50000.0, 0.0, Double.MAX_VALUE);
        this.FUSIONREACTOR_MAXSTORAGE = builder.defineInRange("fusionreactor_max_storage", 1024, 0, Integer.MAX_VALUE);
        this.PARTICLEINJECTOR_USAGE_PER_PARTICLE = builder.defineInRange("particle_injector_usage_per_particle", 2.0E8, 0.0, Double.MAX_VALUE);
        this.GASCENTRIFUGE_USAGE_PER_TICK = builder.defineInRange("gascentrifuge_usage_per_tick", 1500.0, 0.0, Double.MAX_VALUE);
        this.GASCENTRIFUGE_REQUIRED_TICKS_PER_PROCESSING = builder.defineInRange("gascentrifuge_required_ticks", 20, 0, Integer.MAX_VALUE);
        this.FREEZEPLUG_USAGE_PER_TICK = builder.defineInRange("freezeplug_usage_per_tick", 200.0, 0.0, Double.MAX_VALUE);
        this.MOLTENSALTSUPPLIER_VOLTAGE = builder.defineInRange("moltensaltsupplier_voltage", 120.0, 0.0, Double.MAX_VALUE);
        this.MOLTENSALTSUPPLIER_USAGE_PER_TICK = builder.defineInRange("moltensaltsupplier_usage_per_tick", 200.0, 0.0, Double.MAX_VALUE);
        this.ATOMICASSEMBLER_USAGE_PER_TICK = builder.defineInRange("atomicassembler_usage_per_tick", 6000.0, 0.0, Double.MAX_VALUE);
        this.ATOMICASSEMBLER_VOLTAGE = builder.defineInRange("atomicassembler_voltage", 480.0, 0.0, Double.MAX_VALUE);
        this.ATOMICASSEMBLER_REQUIRED_TICKS = builder.defineInRange("atomicassembler_required_ticks", 12000, 0, Integer.MAX_VALUE);
        this.QUANTUM_TUNNEL_FREQUENCY_CAP_PER_PLAYER = builder.defineInRange("quantum_tunnel_frequency_cap_per_player", 40, 0, Integer.MAX_VALUE);
        this.ANTIMATTER_TICKS_ON_GROUND = builder.defineInRange("antimatter_ticks_on_ground", 40, 0, Integer.MAX_VALUE);
        this.CLOUD_CHAMBER_ENERGY_USAGE_PER_TICK = builder.defineInRange("cloud_chamber_energy_usage_per_tick", 100.0, 0.0, Double.MAX_VALUE);
        this.CLOUD_CHAMBER_FLUID_USAGE_PER_TICK = builder.defineInRange("cloud_chamber_fluid_usage_per_tick", 1, 0, Integer.MAX_VALUE);
        this.FALLOUT_SCRUBBER_USAGE_PER_TICK = builder.defineInRange("fallout_scrubber_usage_per_tick", 100.0, 0.0, Double.MAX_VALUE);
        this.ATOMIC_ASSEMBLER_RADIATION_RADIUS = builder.defineInRange("atomic_assembler_radiation_radius", 5, 0, Integer.MAX_VALUE);
        this.CHEMICAL_EXTRACTOR_RADIATION_RADIUS = builder.defineInRange("chemical_extractor_radiation_radius", 3, 0, Integer.MAX_VALUE);
        this.FUEL_REPROCESSOR_RADIATION_RADIUS = builder.defineInRange("fuel_reprocessor_radiation_radius", 10, 0, Integer.MAX_VALUE);
        this.GAS_CENTRIFUGE_RADIATION_RADIUS = builder.defineInRange("gas_centrifuge_radiation_radius", 5, 0, Integer.MAX_VALUE);
        this.NUCLEAR_BOILER_RADIATION_RADIUS = builder.defineInRange("nuclear_boiler_radiation_radius", 5, 0, Integer.MAX_VALUE);
        this.PARTICLE_INJECTOR_RADIATION_RADIUS = builder.defineInRange("particle_injector_radiation_radius", 3, 0, Integer.MAX_VALUE);
        this.RADIOACTIVE_PROCESSOR_RADIATION_RADIUS = builder.defineInRange("radioactive_processor_radiation_radius", 5, 0, Integer.MAX_VALUE);
        this.RADIO_GENATOR_RADIATION_RADIUS = builder.defineInRange("radioisotopegenerator_radiation_radius", 10, 0, Integer.MAX_VALUE);
        this.MOLTEN_SAL_SUPPLIER_RADIATION_RADIUS = builder.defineInRange("molten_salt_supplier_radiation_radius", 5, 0, Integer.MAX_VALUE);
        this.DEFAULT_PARTICLE_COOLDOWN_TICKS = builder.defineInRange("particle_cooldown_tick", 50, 0, Integer.MAX_VALUE);
        this.PARTICLE_SURVIVAL_TICKS = builder.defineInRange("particle_survival_ticks", 800, 0, Integer.MAX_VALUE);
        builder.pop();
        this.SPEC = builder.build();
    }
}

