/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.registers.ElectrodynamicsSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.registers.NuclearScienceRecipies;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.common.inventory.container.ContainerO2OProcessor;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;

public class TileFuelReprocessor
extends GenericTile
implements ITickableSound {
    private boolean isSoundPlaying = false;

    public TileFuelReprocessor(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_FUELREPROCESSOR.get(), pos, state);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(480.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().processors(1, 1, 1, 1).upgrades(3)).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0}).setDirectionsBySlot(Integer.valueOf(1), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).setSlotsByDirection(BlockEntityUtils.MachineDirection.BOTTOM, new Integer[]{2}).validUpgrades(ContainerO2OProcessor.VALID_UPGRADES).valid(TileFuelReprocessor.machineValidator()));
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this).canProcess(this::shouldProcessRecipe).process(ComponentProcessor::processItem2ItemRecipe));
        this.addComponent((IComponent)new ComponentContainerProvider("fuelreprocessor", (GenericTile)this).createMenu((id, player) -> new ContainerO2OProcessor(id.intValue(), player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    private boolean shouldProcessRecipe(ComponentProcessor component, int procNumber) {
        boolean canProcess = component.canProcessItem2ItemRecipe(procNumber, (RecipeType)NuclearScienceRecipies.FUEL_REPROCESSOR_TYPE.get());
        if (BlockEntityUtils.isLit((GenericTile)this) ^ canProcess) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)canProcess);
        }
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)((ComponentInventory)this.getComponent(IComponentType.Inventory)), (int)((Integer)NuclearConfig.INSTANCE.FUEL_REPROCESSOR_RADIATION_RADIUS.get()), (boolean)true, (int)30, (boolean)true, (boolean)false);
        return canProcess;
    }

    public void tickClient(ComponentTickable tickable) {
        if (!this.isSoundPlaying && this.shouldPlaySound()) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_HUM.get()), (BlockEntity)this, (boolean)true);
        }
        if (((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0) && (double)this.getLevel().getRandom().nextFloat() < 0.3) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)this.worldPosition.getX() + this.level.random.nextFloat()), (double)((float)this.worldPosition.getY() + this.level.random.nextFloat()), (double)((float)this.worldPosition.getZ() + this.level.random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0);
    }

    public int getComparatorSignal() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0) ? 15 : 0;
    }
}

