/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.fission;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.Tags;
import nuclearscience.common.block.BlockIrradiated;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class TileMeltedReactor
extends GenericTile {
    public static final float RADIATION_RADIUS = 30.0f;
    public static final float START_RADIATION = 4.383E7f;
    public int radiation = 43830000;
    public int temperature = 6000;

    public TileMeltedReactor(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_MELTEDREACTOR.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
    }

    protected void tickServer(ComponentTickable tickable) {
        BlockState state;
        BlockPos pos;
        double distanceSq;
        double d5;
        double d4;
        double d3;
        double z2;
        double y2;
        BlockState state2;
        long ticks = tickable.getTicks();
        if (ticks % 3L == 0L && ((state2 = this.level.getBlockState(this.worldPosition.below())).isAir() || state2.getBlock() instanceof LiquidBlock)) {
            this.level.setBlockAndUpdate(this.worldPosition.below(), this.getBlockState());
            this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
            BlockEntity tile = this.level.getBlockEntity(this.worldPosition.below());
            if (tile instanceof TileMeltedReactor) {
                TileMeltedReactor newTile = (TileMeltedReactor)tile;
                newTile.radiation = this.radiation;
            }
            return;
        }
        if (this.temperature > 0) {
            --this.temperature;
            double x2 = (double)this.worldPosition.getX() + 0.5 + (this.level.random.nextDouble() - 0.5) * 30.0 / 2.0;
            y2 = (double)this.worldPosition.getY() + 0.5 + (this.level.random.nextDouble() - 0.5) * 30.0 / 2.0;
            z2 = (double)this.worldPosition.getZ() + 0.5 + (this.level.random.nextDouble() - 0.5) * 30.0 / 2.0;
            d3 = (double)this.worldPosition.getX() - x2;
            distanceSq = d3 * d3 + (d4 = (double)this.worldPosition.getY() - y2) * d4 + (d5 = (double)this.worldPosition.getZ() - z2) * d5;
            if (distanceSq < 56.25 && this.level.random.nextDouble() > distanceSq / 900.0) {
                pos = new BlockPos((int)Math.floor(x2), (int)Math.floor(y2), (int)Math.floor(z2));
                state = this.level.getBlockState(pos);
                if (state.isAir()) {
                    if (!this.level.getBlockState(pos.below()).isAir()) {
                        this.level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    }
                } else if (state.is(BlockTags.BASE_STONE_OVERWORLD) || state.is(Tags.Blocks.ORES)) {
                    if (this.temperature > 2100) {
                        this.level.setBlockAndUpdate(pos, Blocks.COBBLESTONE.defaultBlockState());
                    }
                } else if (state.is(Tags.Blocks.COBBLESTONES) || state.is(Tags.Blocks.GRAVELS)) {
                    this.level.setBlockAndUpdate(pos, Blocks.LAVA.defaultBlockState());
                } else if (this.level.getFluidState(pos).is(FluidTags.WATER)) {
                    this.level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                } else if (state.is(BlockTags.SAND)) {
                    this.level.setBlockAndUpdate(pos, Blocks.GLASS.defaultBlockState());
                }
            }
        }
        if (this.radiation > 0) {
            --this.radiation;
            double x2 = (double)this.worldPosition.getX() + 0.5 + (this.level.random.nextDouble() - 0.5) * 30.0 / 2.0;
            y2 = (double)this.worldPosition.getY() + 0.5 + (this.level.random.nextDouble() - 0.5) * 30.0 / 2.0;
            z2 = (double)this.worldPosition.getZ() + 0.5 + (this.level.random.nextDouble() - 0.5) * 30.0 / 2.0;
            d3 = (double)this.worldPosition.getX() - x2;
            distanceSq = d3 * d3 + (d4 = (double)this.worldPosition.getY() - y2) * d4 + (d5 = (double)this.worldPosition.getZ() - z2) * d5;
            if (distanceSq < 56.25 && this.level.random.nextDouble() > distanceSq / 900.0 && BlockIrradiated.isValidPlacement(state = this.level.getBlockState(pos = new BlockPos((int)Math.floor(x2), (int)Math.floor(y2), (int)Math.floor(z2))))) {
                this.level.setBlockAndUpdate(pos, BlockIrradiated.getIrradiatedBlockstate(state));
            }
        }
        double totstrength = 120000.0f * ((float)this.radiation / 4.383E7f);
        int range = (int)(Math.sqrt(totstrength) / (5.0 * Math.sqrt(2.0)) * 2.0);
        RadiationSystem.addRadiationSource((Level)this.getLevel(), (SimpleRadiationSource)new SimpleRadiationSource(totstrength, 1.0, range, true, 30, this.getBlockPos(), true, false));
    }

    public ItemInteractionResult useWithItem(ItemStack used, Player player, InteractionHand hand, BlockHitResult hit) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(Player player, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        compound.putInt("rads", this.radiation);
        compound.putInt("temp", this.temperature);
        super.saveAdditional(compound, registries);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        this.radiation = compound.getInt("rads");
        this.temperature = compound.getInt("temp");
        super.loadAdditional(compound, registries);
    }
}

