/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.fusion;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import nuclearscience.common.block.BlockPlasma;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.common.tile.reactor.fusion.TilePlasma;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileFusionReactorCore
extends GenericTile {
    public final SingleProperty<Integer> deuterium = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "deuterium", (Object)0));
    public final SingleProperty<Integer> tritium = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "tritium", (Object)0));
    public final SingleProperty<Integer> timeLeft = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "timeleft", (Object)0));

    public TileFusionReactorCore(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_FUSIONREACTORCORE.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM}).maxJoules((Double)NuclearConfig.INSTANCE.FUSIONREACTOR_USAGE_PER_TICK.get() * 20.0).voltage(480.0));
    }

    public void tickServer(ComponentTickable tick) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if ((Integer)this.tritium.getValue() > 0 && (Integer)this.deuterium.getValue() > 0 && (Integer)this.timeLeft.getValue() <= 0 && electro.getJoulesStored() > (Double)NuclearConfig.INSTANCE.FUSIONREACTOR_USAGE_PER_TICK.get()) {
            this.deuterium.setValue((Object)((Integer)this.deuterium.getValue() - 1));
            this.tritium.setValue((Object)((Integer)this.tritium.getValue() - 1));
            this.timeLeft.setValue((Object)300);
        }
        if ((Integer)this.timeLeft.getValue() <= 0) {
            if (BlockEntityUtils.isLit((GenericTile)this)) {
                BlockEntityUtils.updateLit((GenericTile)this, (Boolean)false);
            }
            return;
        }
        if (!BlockEntityUtils.isLit((GenericTile)this)) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)true);
        }
        this.timeLeft.setValue((Object)((Integer)this.timeLeft.getValue() - 1));
        if (electro.getJoulesStored() < (Double)NuclearConfig.INSTANCE.FUSIONREACTOR_USAGE_PER_TICK.get()) {
            return;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos offset = this.worldPosition.relative(dir);
            BlockState offsetState = this.level.getBlockState(offset);
            if (offsetState.getBlock() == NuclearScienceBlocks.BLOCK_PLASMA.get()) {
                BlockEntity tile = this.level.getBlockEntity(offset);
                if (!(tile instanceof TilePlasma)) continue;
                TilePlasma plasma = (TilePlasma)tile;
                if ((Integer)plasma.ticksExisted.getValue() <= 30) continue;
                plasma.ticksExisted.setValue((Object)0);
                continue;
            }
            if (!offsetState.isAir()) continue;
            this.level.setBlockAndUpdate(offset, ((BlockPlasma)((Object)NuclearScienceBlocks.BLOCK_PLASMA.get())).defaultBlockState());
        }
        electro.joules(electro.getJoulesStored() - (Double)NuclearConfig.INSTANCE.FUSIONREACTOR_USAGE_PER_TICK.get());
    }

    public ItemInteractionResult useWithItem(ItemStack used, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack inHand = player.getItemInHand(hand);
        int accepted = 0;
        if (inHand.is(NuclearScienceTags.Items.CELL_DEUTERIUM)) {
            accepted = this.addDeuteriumCells(inHand.getCount());
        } else if (inHand.is(NuclearScienceTags.Items.CELL_TRITIUM)) {
            accepted = this.addTritiumCells(inHand.getCount());
        }
        if (accepted > 0) {
            if (!this.level.isClientSide()) {
                inHand.setCount(inHand.getCount() - accepted);
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public int addDeuteriumCells(int count) {
        return this.addCell(this.deuterium, count);
    }

    public int addTritiumCells(int count) {
        return this.addCell(this.tritium, count);
    }

    private int addCell(SingleProperty<Integer> property, int count) {
        if ((Integer)property.getValue() >= (Integer)NuclearConfig.INSTANCE.FUSIONREACTOR_MAXSTORAGE.get()) {
            return 0;
        }
        int added = Math.min(count, (Integer)NuclearConfig.INSTANCE.FUSIONREACTOR_MAXSTORAGE.get() - (Integer)property.getValue());
        if (!this.level.isClientSide()) {
            property.setValue((Object)((Integer)property.getValue() + added));
        }
        return added;
    }

    public boolean isDeuteriumFull() {
        return (Integer)this.deuterium.getValue() >= (Integer)NuclearConfig.INSTANCE.FUSIONREACTOR_MAXSTORAGE.get();
    }

    public boolean isTritiumFull() {
        return (Integer)this.tritium.getValue() >= (Integer)NuclearConfig.INSTANCE.FUSIONREACTOR_MAXSTORAGE.get();
    }
}

