/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.datagen.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import nuclearscience.common.block.subtype.SubtypeNuclearMachine;
import nuclearscience.registers.NuclearScienceItems;

public class AtomicAssemblerBlacklistProvider
implements DataProvider {
    public static final String LOC = "data/nuclearscience/machines/atomic_assembler_blacklist";
    private final PackOutput output;

    public AtomicAssemblerBlacklistProvider(PackOutput output) {
        this.output = output;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        JsonObject json = new JsonObject();
        AtomicAssemblerBlacklistProvider.getFuels(json);
        Path parent = this.output.getOutputFolder().resolve("data/nuclearscience/machines/atomic_assembler_blacklist.json");
        return CompletableFuture.allOf(DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)parent));
    }

    private static void getFuels(JsonObject object) {
        JsonArray json = new JsonArray();
        AtomicAssemblerBlacklistProvider.addItem(Items.AIR, json);
        AtomicAssemblerBlacklistProvider.addTag((TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"air")), json);
        AtomicAssemblerBlacklistProvider.addItem((Item)NuclearScienceItems.ITEMS_NUCLEARMACHINE.getValue((Object)SubtypeNuclearMachine.teleporter), json);
        AtomicAssemblerBlacklistProvider.addItem((Item)NuclearScienceItems.ITEMS_NUCLEARMACHINE.getValue((Object)SubtypeNuclearMachine.quantumcapacitor), json);
        AtomicAssemblerBlacklistProvider.addItem((Item)NuclearScienceItems.ITEMS_NUCLEARMACHINE.getValue((Object)SubtypeNuclearMachine.chunkloader), json);
        object.add("values", (JsonElement)json);
    }

    private static void addTag(TagKey<Item> item, JsonArray json) {
        json.add("#" + item.location().toString());
    }

    private static void addItem(Item item, JsonArray json) {
        json.add(BuiltInRegistries.ITEM.getKey((Object)item).toString());
    }

    public String getName() {
        return "Nuclear Science Atomic Assembler Blacklist Provider";
    }
}

