/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.prefab.screen.component;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import nuclearscience.common.tile.reactor.moltensalt.TileMSReactorCore;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.prefab.inventory.container.types.GenericContainerBlockEntity;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.gauges.AbstractScreenComponentGauge;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

public class ScreenComponentReactorFuel
extends AbstractScreenComponentGauge {
    public ScreenComponentReactorFuel(int x, int y) {
        super(x, y);
    }

    protected void applyColor() {
        RenderingUtils.setShaderColor((Color)new Color(IClientFluidTypeExtensions.of((Fluid)Fluids.LAVA).getTintColor()));
    }

    protected int getScaledLevel() {
        TileMSReactorCore core = (TileMSReactorCore)((GenericContainerBlockEntity)((GenericScreen)this.gui).getMenu()).getSafeHost();
        if (core == null) {
            return 0;
        }
        return (int)((double)(AbstractScreenComponentGauge.GaugeTextures.BACKGROUND_DEFAULT.textureHeight() - 2) * (Double)core.currentFuel.getValue() / 1000.0);
    }

    protected ResourceLocation getTexture() {
        return IClientFluidTypeExtensions.of((Fluid)Fluids.LAVA).getStillTexture();
    }

    protected List<? extends FormattedCharSequence> getTooltips() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileMSReactorCore core = (TileMSReactorCore)((GenericContainerBlockEntity)((GenericScreen)this.gui).getMenu()).getSafeHost();
        if (core == null) {
            return list;
        }
        list.add(VoltaicTextUtils.ratio((Component)ChatFormatter.formatFluidMilibuckets((double)((Double)core.currentFuel.getValue())), (Component)ChatFormatter.formatFluidMilibuckets((double)1000.0)).withStyle(ChatFormatting.GRAY).getVisualOrderText());
        return list;
    }
}

