/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.prefab.screen.component.logisticsnetwork;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import nuclearscience.api.network.reactorlogistics.Interface;
import nuclearscience.client.screen.util.GenericInterfaceBoundScreen;
import nuclearscience.common.inventory.container.util.GenericInterfaceBoundContainer;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.util.GenericTileInterfaceBound;
import nuclearscience.prefab.screen.component.quantumtunnel.QuantumTunnelTextures;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.utilities.math.Color;

public class ButtonInterfaceType
extends ScreenComponentButton<ButtonInterfaceType> {
    private Interface bound;
    private boolean isSelected = false;

    public ButtonInterfaceType(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (!this.isVisible()) {
            return;
        }
        GenericInterfaceBoundScreen screen = (GenericInterfaceBoundScreen)this.gui;
        GenericTileInterfaceBound tile = (GenericTileInterfaceBound)((GenericInterfaceBoundContainer)screen.getMenu()).getSafeHost();
        if (tile == null) {
            return;
        }
        QuantumTunnelTextures texture = this.bound != null && (((BlockPos)tile.interfaceLocation.getValue()).equals((Object)this.bound.pos()) || this.isSelected || this.isHovered()) ? QuantumTunnelTextures.FREQUENCY_SELECTED : QuantumTunnelTextures.FREQUENCY;
        ScreenComponentEditBox.drawExpandedBox((GuiGraphics)graphics, (ResourceLocation)texture.getLocation(), (int)(this.xLocation + guiWidth), (int)(this.yLocation + guiHeight), (int)this.width, (int)this.height);
        if (this.bound == null) {
            return;
        }
        graphics.renderItem(GenericTileInterface.getItemFromType(this.bound.type()), guiWidth + this.xLocation + 2, guiHeight + this.yLocation + 2);
        Font font = screen.getFontRenderer();
        MutableComponent text = Component.literal((String)this.bound.pos().toShortString());
        int xOffset = 20;
        int maxWidth = this.width - xOffset - 2;
        int width = font.width((FormattedText)text);
        float scale = 1.0f;
        float addY = 0.0f;
        if (width > maxWidth) {
            scale = (float)maxWidth / (float)width;
            Objects.requireNonNull(font);
            Objects.requireNonNull(font);
            addY = (9.0f - 9.0f * scale) / 2.0f / scale;
        }
        graphics.pose().pushPose();
        graphics.pose().translate((float)(guiWidth + this.xLocation), (float)(guiHeight + this.yLocation), 0.0f);
        graphics.pose().scale(scale, scale, 0.0f);
        graphics.drawString(font, text.getVisualOrderText(), (float)xOffset / scale, 7.0f / scale + addY, Color.TEXT_GRAY.color(), false);
        graphics.pose().popPose();
    }

    public void setInterface(Interface bound) {
        this.bound = bound;
    }

    public Interface getInterface() {
        return this.bound;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }
}

