/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.prefab.sound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import nuclearscience.common.entity.EntityParticle;
import voltaic.prefab.utilities.WorldUtils;

public class TickableSoundParticle
extends AbstractTickableSoundInstance {
    private static final float MIN_PITCH = 0.5f;
    private static final float MAXIMUM_DISTANCE = 100.0f;
    private final EntityParticle particle;
    private final float initialVolume;

    public TickableSoundParticle(SoundEvent event, SoundSource source, EntityParticle particle) {
        super(event, source, SoundInstance.createUnseededRandom());
        this.particle = particle;
        this.x = particle.getX();
        this.y = particle.getY();
        this.z = particle.getZ();
        this.initialVolume = 1.0f;
        this.volume = 1.0f;
        this.pitch = 0.5f;
        this.looping = true;
        this.delay = 0;
        this.relative = true;
    }

    public void tick() {
        float ratio = Math.abs(this.particle.speed / 2.0f) / 2.0f;
        this.pitch = 0.5f + 0.5f * ratio;
        this.x = this.particle.getX();
        this.y = this.particle.getY();
        this.z = this.particle.getZ();
        LocalPlayer player = Minecraft.getInstance().player;
        float distance = (float)WorldUtils.distanceBetweenPositions((BlockPos)player.blockPosition(), (BlockPos)new BlockPos((int)this.x, (int)this.y, (int)this.z));
        if (distance > 0.0f && distance <= 100.0f) {
            float distRatio = distance / 100.0f;
            this.volume = (1.0f - distRatio) * this.initialVolume;
        } else {
            this.volume = distance > 100.0f ? 0.0f : this.initialVolume;
        }
    }

    public boolean isStopped() {
        return this.particle == null || !this.particle.isAlive() || this.particle.isRemoved();
    }
}

