/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.api.quantumtunnel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.api.quantumtunnel.TunnelFrequencyBuffer;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.registers.NuclearScienceAttachmentTypes;

public class TunnelFrequencyManager {
    public static void addPlayerFrequency(UUID player, TunnelFrequency frequency) {
        ServerLevel level = TunnelFrequencyManager.getOverworld();
        HashMap map = (HashMap)level.getData(NuclearScienceAttachmentTypes.CHANNEL_MAP);
        if (!map.containsKey(player)) {
            map.put(player, new HashSet());
        }
        ((HashSet)map.get(player)).add(frequency);
        level.setData(NuclearScienceAttachmentTypes.CHANNEL_MAP, (Object)map);
    }

    public static void addPublicFrequency(TunnelFrequency frequency) {
        TunnelFrequencyManager.addPlayerFrequency(TunnelFrequency.PUBLIC_ID, frequency);
    }

    public static void removePlayerFrequency(UUID player, UUID requester, TunnelFrequency frequency) {
        if (!frequency.getCreatorId().equals(requester)) {
            return;
        }
        ServerLevel level = TunnelFrequencyManager.getOverworld();
        HashMap map = (HashMap)level.getData(NuclearScienceAttachmentTypes.CHANNEL_MAP);
        if (!map.containsKey(player)) {
            return;
        }
        ((HashSet)map.get(player)).remove(frequency);
        level.setData(NuclearScienceAttachmentTypes.CHANNEL_MAP, (Object)map);
    }

    public static void removePublicFrequency(UUID requester, TunnelFrequency frequency) {
        TunnelFrequencyManager.removePlayerFrequency(TunnelFrequency.PUBLIC_ID, requester, frequency);
    }

    public static boolean isValidTunnelID(UUID proposedFrequencyID) {
        ServerLevel level = TunnelFrequencyManager.getOverworld();
        HashMap map = (HashMap)level.getData(NuclearScienceAttachmentTypes.CHANNEL_MAP);
        for (Map.Entry entry : map.entrySet()) {
            if (((HashSet)entry.getValue()).size() > (Integer)NuclearConfig.INSTANCE.QUANTUM_TUNNEL_FREQUENCY_CAP_PER_PLAYER.get()) {
                return false;
            }
            for (TunnelFrequency id : (HashSet)entry.getValue()) {
                if (!id.getId().equals(proposedFrequencyID)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean doesFrequencyExist(TunnelFrequency tunnelFrequency) {
        ServerLevel level = TunnelFrequencyManager.getOverworld();
        HashMap map = (HashMap)level.getData(NuclearScienceAttachmentTypes.CHANNEL_MAP);
        for (Map.Entry entry : map.entrySet()) {
            for (TunnelFrequency id : (HashSet)entry.getValue()) {
                if (!id.equals(tunnelFrequency)) continue;
                return true;
            }
        }
        return false;
    }

    public static void updatePlayerFrequencyName(UUID player, UUID requester, TunnelFrequency frequency) {
        if (!frequency.getCreatorId().equals(requester)) {
            return;
        }
        ServerLevel level = TunnelFrequencyManager.getOverworld();
        HashMap map = (HashMap)level.getData(NuclearScienceAttachmentTypes.CHANNEL_MAP);
        if (!map.containsKey(player)) {
            map.put(player, new HashSet());
        }
        ((HashSet)map.get(player)).remove(frequency);
        ((HashSet)map.get(player)).add(frequency);
        HashMap connectionMap = (HashMap)level.getData(NuclearScienceAttachmentTypes.TUNNEL_MAP);
        TunnelFrequencyBuffer buffer = connectionMap.getOrDefault(frequency, new TunnelFrequencyBuffer());
        connectionMap.remove(frequency);
        connectionMap.put(frequency, buffer);
        level.setData(NuclearScienceAttachmentTypes.CHANNEL_MAP, (Object)map);
        level.setData(NuclearScienceAttachmentTypes.TUNNEL_MAP, (Object)connectionMap);
    }

    public static void updatePublicFrequencyName(UUID requester, TunnelFrequency frequency) {
        TunnelFrequencyManager.updatePlayerFrequencyName(TunnelFrequency.PUBLIC_ID, requester, frequency);
    }

    public static HashMap<UUID, HashSet<TunnelFrequency>> getFrequenciesForPlayerClient(UUID playerID) {
        HashMap<UUID, HashSet<TunnelFrequency>> values = new HashMap<UUID, HashSet<TunnelFrequency>>();
        ServerLevel level = TunnelFrequencyManager.getOverworld();
        HashMap map = (HashMap)level.getData(NuclearScienceAttachmentTypes.CHANNEL_MAP);
        values.put(TunnelFrequency.PUBLIC_ID, map.getOrDefault(TunnelFrequency.PUBLIC_ID, new HashSet()));
        values.put(playerID, map.getOrDefault(playerID, new HashSet()));
        return values;
    }

    public static void wipeAllFrequencies() {
        ServerLevel level = TunnelFrequencyManager.getOverworld();
        level.setData(NuclearScienceAttachmentTypes.CHANNEL_MAP, new HashMap());
        level.setData(NuclearScienceAttachmentTypes.TUNNEL_MAP, new HashMap());
    }

    public static void wipePublicFrequencies() {
        ServerLevel level = TunnelFrequencyManager.getOverworld();
        HashMap map = (HashMap)level.getData(NuclearScienceAttachmentTypes.CHANNEL_MAP);
        HashMap connectionMap = (HashMap)level.getData(NuclearScienceAttachmentTypes.TUNNEL_MAP);
        HashSet publicFrequencies = map.getOrDefault(TunnelFrequency.PUBLIC_ID, new HashSet());
        if (publicFrequencies.isEmpty()) {
            return;
        }
        for (TunnelFrequency frequency : publicFrequencies) {
            connectionMap.remove(frequency);
        }
        map.remove(TunnelFrequency.PUBLIC_ID);
        level.setData(NuclearScienceAttachmentTypes.CHANNEL_MAP, (Object)map);
        level.setData(NuclearScienceAttachmentTypes.TUNNEL_MAP, (Object)connectionMap);
    }

    private static ServerLevel getOverworld() {
        return ServerLifecycleHooks.getCurrentServer().overworld();
    }
}

