/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import nuclearscience.common.entity.EntityParticle;
import voltaic.prefab.utilities.RenderingUtils;

public class RenderParticle
extends EntityRenderer<EntityParticle> {
    private static final float MAX_SCALE = 0.02f;
    private static final float MIN_SCALE = 0.01f;
    private static final float DELTA_SCALE = 0.01f;

    public RenderParticle(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(EntityParticle entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float scale;
        matrixStackIn.pushPose();
        float perc = (float)(500L - System.currentTimeMillis() % 1000L) / 500.0f;
        if (perc < 0.0f) {
            scale = 0.02f - 0.01f * (perc *= -1.0f);
        } else {
            perc = 1.0f - perc;
            scale = 0.01f + 0.01f * perc;
        }
        matrixStackIn.scale(scale, scale, scale);
        RenderingUtils.renderStar((PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (float)((float)entityIn.tickCount + partialTicks), (int)60, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f, (boolean)true);
        matrixStackIn.popPose();
    }

    public ResourceLocation getTextureLocation(EntityParticle entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

