/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.event.levelstage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import nuclearscience.common.tile.TileCloudChamber;
import org.joml.Matrix4f;
import voltaic.client.event.AbstractLevelStageHandler;

public class HandlerCloudChamber
extends AbstractLevelStageHandler {
    public static final HandlerCloudChamber INSTANCE = new HandlerCloudChamber();
    private HashSet<TileCloudChamber> locations = new HashSet();

    public boolean shouldRender(RenderLevelStageEvent.Stage stage) {
        return stage == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS;
    }

    public void render(Camera camera, Frustum frustum, LevelRenderer levelRenderer, PoseStack poseStack, Matrix4f matrix4f, Minecraft minecraft, int renderTick, DeltaTracker deltaTracker) {
        MultiBufferSource.BufferSource buffer = minecraft.renderBuffers().bufferSource();
        VertexConsumer builder = buffer.getBuffer((RenderType)RenderType.LINES);
        Vec3 camPos = camera.getPosition();
        Iterator<TileCloudChamber> it = this.locations.iterator();
        while (it.hasNext()) {
            TileCloudChamber chamber = it.next();
            if (chamber == null || chamber.isRemoved() || !chamber.hasLevel() || !chamber.getLevel().isLoaded(chamber.getBlockPos()) || !((Boolean)chamber.active.getValue()).booleanValue()) {
                it.remove();
                continue;
            }
            ((List)chamber.sources.getValue()).forEach(source -> {
                AABB outline = new AABB(source);
                if (!frustum.isVisible(outline)) {
                    return;
                }
                poseStack.pushPose();
                poseStack.translate(-camPos.x, -camPos.y, -camPos.z);
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)builder, (AABB)outline, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.popPose();
            });
        }
        buffer.endBatch((RenderType)RenderType.LINES);
    }

    public void clear() {
        this.locations.clear();
    }

    public static void addSources(TileCloudChamber chamber) {
        HandlerCloudChamber.INSTANCE.locations.add(chamber);
    }

    public static void removeSources(TileCloudChamber chamber) {
        HandlerCloudChamber.INSTANCE.locations.remove((Object)chamber);
    }
}

