/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import nuclearscience.client.NuclearScienceClientRegister;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileControlRodModule;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.Color;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderControlRodModule
extends AbstractTileRenderer<TileControlRodModule> {
    private static final double MAX_DELTA = 0.8125;

    public RenderControlRodModule(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull TileControlRodModule tile, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        stack.pushPose();
        stack.translate(0.5, 0.5, 0.5);
        Direction facing = tile.getFacing();
        int sign = 1;
        if (facing == Direction.WEST || facing == Direction.EAST) {
            sign = -1;
        }
        stack.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)(facing.toYRot() - (float)(sign * 90)), (float)0.0f));
        double insertion = (double)((Integer)tile.insertion.getValue()).intValue() / 100.0;
        stack.translate(0.0, 0.0, -0.8125 * insertion);
        RenderingUtils.renderModel((BakedModel)this.getModel(NuclearScienceClientRegister.MODEL_CONTROLRODMODULE_ROD), (BlockEntity)tile, (RenderType)RenderType.solid(), (PoseStack)stack, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        stack.popPose();
        if (!((Boolean)tile.linked.getValue()).booleanValue()) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        stack.pushPose();
        stack.translate(0.5, 0.5, 0.5);
        RenderControlRodModule.rotateMatrix(stack, facing);
        stack.translate(0.0, 0.175, 0.1775);
        MutableComponent transfer = ChatFormatter.getChatDisplayShort((double)((double)((Integer)tile.insertion.getValue()).intValue() / 100.0 * 100.0), (IDisplayUnit)DisplayUnits.PERCENTAGE);
        float scale = 0.0215f / ((float)font.width((FormattedText)transfer) / 16.0f);
        stack.scale(-scale, -scale, -scale);
        Matrix4f matrix4f = stack.last().pose();
        float textX = (float)(-font.width((FormattedText)transfer)) / 2.0f;
        font.drawInBatch((Component)transfer, textX, 0.0f, Color.WHITE.color(), false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, 0, combinedLightIn);
        stack.popPose();
    }

    private static void rotateMatrix(PoseStack stack, Direction dir) {
        switch (dir) {
            case EAST: {
                stack.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)-90.0f, (float)0.0f));
                break;
            }
            case SOUTH: {
                stack.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)180.0f, (float)0.0f));
                break;
            }
            case WEST: {
                stack.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)90.0f, (float)0.0f));
                break;
            }
        }
    }
}

