/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.block.entity.BlockEntity;
import nuclearscience.client.NuclearScienceClientRegister;
import nuclearscience.client.particle.smoke.ParticleOptionSmoke;
import nuclearscience.common.tile.TileFalloutScrubber;
import org.jetbrains.annotations.NotNull;
import voltaic.Voltaic;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderFalloutScrubber
extends AbstractTileRenderer<TileFalloutScrubber> {
    public RenderFalloutScrubber(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull TileFalloutScrubber tile, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        stack.pushPose();
        stack.translate(0.5, 0.5, 0.5);
        Direction facing = tile.getFacing();
        float roat = 0.0f;
        if (((Boolean)tile.active.getValue()).booleanValue()) {
            roat = (float)(System.currentTimeMillis() % 150L) / 150.0f * 90.0f;
        }
        if (facing == Direction.EAST) {
            stack.mulPose(MathUtils.rotQuaternionDeg((float)(-roat), (float)0.0f, (float)0.0f));
        } else if (facing == Direction.WEST) {
            stack.mulPose(MathUtils.rotQuaternionDeg((float)roat, (float)0.0f, (float)0.0f));
        } else if (facing == Direction.NORTH) {
            stack.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)90.0f, (float)0.0f));
            stack.mulPose(MathUtils.rotQuaternionDeg((float)(-roat), (float)0.0f, (float)0.0f));
        } else if (facing == Direction.SOUTH) {
            stack.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)90.0f, (float)0.0f));
            stack.mulPose(MathUtils.rotQuaternionDeg((float)roat, (float)0.0f, (float)0.0f));
        }
        BlockPos pos = tile.getBlockPos();
        Random random = Voltaic.RANDOM;
        RenderingUtils.renderModel((BakedModel)this.getModel(NuclearScienceClientRegister.MODEL_FALLOUTSCRUBBER_FAN), (BlockEntity)tile, (RenderType)RenderType.solid(), (PoseStack)stack, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        stack.popPose();
        if (!((Boolean)tile.active.getValue()).booleanValue() || random.nextFloat() > 0.4f) {
            return;
        }
        double offset = 1.0 + random.nextDouble(0.5);
        double x = (double)pos.getX() + random.nextDouble(0.75) + 0.125;
        double y = (double)pos.getY() + Voltaic.RANDOM.nextDouble(0.75) + 0.12;
        double z = (double)pos.getZ() + random.nextDouble(0.75) + 0.12;
        int lifetime = (int)(10.0 * offset);
        float inColor = random.nextFloat(0.5f);
        float outColor = random.nextFloat(0.3f) + 0.7f;
        this.minecraft().particleEngine.createParticle((ParticleOptions)new ParticleOptionSmoke().setParameters(inColor, inColor, inColor, 0.1f * random.nextFloat(), 0.0f, lifetime, false), x + (double)(-facing.getStepX()) * offset, y, z + (double)(-facing.getStepZ()) * offset, (double)facing.getStepX() * 0.05, 0.0, (double)facing.getStepZ() * 0.05);
        this.minecraft().particleEngine.createParticle((ParticleOptions)new ParticleOptionSmoke().setParameters(outColor, outColor, outColor, 0.1f * random.nextFloat(), 0.0f, lifetime, false), x + 0.5 * (double)facing.getStepX(), y, z + 0.5 * (double)facing.getStepZ(), (double)facing.getStepX() * 0.05, 0.0, (double)facing.getStepZ() * 0.05);
    }
}

