/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import nuclearscience.common.tile.reactor.fusion.TileFusionReactorCore;
import nuclearscience.prefab.utils.NuclearTextUtils;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.utilities.math.Color;

public class RenderFusionReactorCore
extends AbstractTileRenderer<TileFusionReactorCore> {
    public RenderFusionReactorCore(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileFusionReactorCore tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockPos pos = tileEntityIn.getBlockPos();
        if (Minecraft.getInstance().player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 32.0) {
            this.renderFloatingText(matrixStackIn, bufferIn, (Component)NuclearTextUtils.tooltip("deuteriumlevel", tileEntityIn.deuterium.getValue()), 0.5f, 1.7f, 0.5f, Color.WHITE.color(), combinedLightIn);
            this.renderFloatingText(matrixStackIn, bufferIn, (Component)NuclearTextUtils.tooltip("tritiumlevel", tileEntityIn.tritium.getValue()), 0.5f, 1.3f, 0.5f, Color.WHITE.color(), combinedLightIn);
            this.renderFloatingText(matrixStackIn, bufferIn, (Component)NuclearTextUtils.tooltip("deuteriumlevel", tileEntityIn.deuterium.getValue()), 0.5f, -0.3f, 0.5f, Color.WHITE.color(), combinedLightIn);
            this.renderFloatingText(matrixStackIn, bufferIn, (Component)NuclearTextUtils.tooltip("tritiumlevel", tileEntityIn.tritium.getValue()), 0.5f, -0.7f, 0.5f, Color.WHITE.color(), combinedLightIn);
        }
    }

    public void renderFloatingText(PoseStack matrixStackIn, MultiBufferSource bufferIn, Component text, float x, float y, float z, int color, int combinedLightIn) {
        matrixStackIn.pushPose();
        matrixStackIn.translate(x, y, z);
        matrixStackIn.scale(-0.025f, -0.025f, 0.025f);
        Camera camera = this.minecraft().getEntityRenderDispatcher().camera;
        matrixStackIn.mulPose(new Quaternionf().rotationYXZ((float)Math.toRadians(camera.getYRot()), (float)Math.toRadians(-camera.getXRot()), 0.0f));
        Matrix4f matrix4f = matrixStackIn.last().pose();
        int backgroundColor = (int)(this.minecraft().options.getBackgroundOpacity(0.76f) * 255.0f) << 24;
        Font font = Minecraft.getInstance().font;
        float xOffset = (float)(-font.width((FormattedText)text)) / 2.0f;
        font.drawInBatch(text, xOffset, 0.0f, color, false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, backgroundColor, combinedLightIn);
        matrixStackIn.popPose();
    }

    public AABB getRenderBoundingBox(TileFusionReactorCore blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity);
    }
}

