/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import nuclearscience.common.tile.TileNuclearBoiler;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.PropertyGasTank;
import voltaic.client.VoltaicClientRegister;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentGasHandlerMulti;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.Color;

public class RenderNuclearBoiler
extends AbstractTileRenderer<TileNuclearBoiler> {
    private static final float DELTA_Y = 0.225f;

    public RenderNuclearBoiler(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileNuclearBoiler tile, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int light, int overlay) {
        matrix.pushPose();
        Direction facing = tile.getFacing();
        VertexConsumer builder = buffer.getBuffer(Sheets.translucentCullBlockSheet());
        PropertyFluidTank input = ((ComponentFluidHandlerMulti)tile.getComponent(IComponentType.FluidHandler)).getInputTanks()[0];
        if (!input.isEmpty()) {
            this.drawFluidInput(matrix, builder, input.getFluid(), facing, (float)input.getFluidAmount() / 5000.0f, light, overlay);
        }
        matrix.popPose();
        matrix.pushPose();
        PropertyGasTank output = ((ComponentGasHandlerMulti)tile.getComponent(IComponentType.GasHandler)).getOutputTanks()[0];
        if (!output.isEmpty()) {
            RenderNuclearBoiler.drawGasOutput(matrix, builder, output.getGas(), facing, (float)output.getGasAmount() / 5000.0f, light, overlay);
        }
        matrix.popPose();
    }

    private void drawFluidInput(PoseStack stack, VertexConsumer builder, FluidStack fluid, Direction facing, float height, int light, int overlay) {
        AABB box = null;
        float maxY = 0.225f * height + 0.5125f;
        box = facing == Direction.NORTH ? new AABB(0.54375, 0.5125, 0.3875, 0.70625, (double)maxY, 0.6125) : (facing == Direction.EAST ? new AABB(0.3875, 0.5125, 0.54375, 0.6125, (double)maxY, 0.70625) : (facing == Direction.SOUTH ? new AABB(0.29375, 0.5125, 0.3875, 0.45625, (double)maxY, 0.6125) : new AABB(0.3875, 0.5125, 0.29375, 0.6125, (double)maxY, 0.45625)));
        RenderingUtils.renderFluidBox((PoseStack)stack, (Minecraft)this.minecraft(), (VertexConsumer)builder, (AABB)box, (FluidStack)fluid, (int)light, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
    }

    private static void drawGasOutput(PoseStack stack, VertexConsumer builder, GasStack fluid, Direction facing, float height, int light, int overlay) {
        AABB box = null;
        float maxY = 0.225f * height + 0.5125f;
        box = facing == Direction.NORTH ? new AABB(0.29375, 0.5125, 0.3875, 0.45625, (double)maxY, 0.6125) : (facing == Direction.EAST ? new AABB(0.3875, 0.5125, 0.29375, 0.6125, (double)maxY, 0.45625) : (facing == Direction.SOUTH ? new AABB(0.54375, 0.5125, 0.3875, 0.70625, (double)maxY, 0.6125) : new AABB(0.3875, 0.5125, 0.54375, 0.6125, (double)maxY, 0.70625)));
        TextureAtlasSprite sprite = VoltaicClientRegister.getSprite((ResourceLocation)VoltaicClientRegister.TEXTURE_GAS);
        float[] colors = new Color(sprite.getPixelRGBA(0, 10, 10)).colorFloatArr();
        RenderingUtils.renderFilledBox((PoseStack)stack, (VertexConsumer)builder, (AABB)box, (float)colors[0], (float)colors[1], (float)colors[2], (float)colors[3], (float)sprite.getU0(), (float)sprite.getV0(), (float)sprite.getU1(), (float)sprite.getV1(), (int)light, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
    }

    public AABB getRenderBoundingBox(TileNuclearBoiler blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity).inflate(1.0);
    }
}

