/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import nuclearscience.common.tile.TileTeleporter;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;

public class RenderTeleporter
extends AbstractTileRenderer<TileTeleporter> {
    public RenderTeleporter(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileTeleporter tileEntityIn, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        stack.pushPose();
        stack.translate(0.5, 0.5, 0.5);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)tileEntityIn.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() > 0.0) {
            AABB bb = AABB.encapsulatingFullBlocks((BlockPos)tileEntityIn.getBlockPos(), (BlockPos)tileEntityIn.getBlockPos().offset(1, 2, 1));
            List player = tileEntityIn.getLevel().getEntities((EntityTypeTest)EntityType.PLAYER, bb, en -> true);
            if (!player.isEmpty()) {
                stack.pushPose();
                stack.popPose();
            }
        }
        stack.popPose();
    }

    public AABB getRenderBoundingBox(TileTeleporter blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity).inflate(3.0);
    }
}

