/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import nuclearscience.NuclearScience;
import nuclearscience.common.inventory.container.ContainerFissionReactorCore;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.screen.component.types.ScreenComponentProgress;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentTemperature;
import voltaic.prefab.screen.component.types.wrapper.WrapperInventoryIO;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;

public class ScreenFissionReactorCore
extends GenericScreen<ContainerFissionReactorCore> {
    public static final ResourceLocation SCREEN_BACKGROUND = NuclearScience.rl("textures/gui/fissionreactor.png");

    public ScreenFissionReactorCore(ContainerFissionReactorCore container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.imageHeight += 10;
        this.inventoryLabelY += 10;
        this.addComponent((AbstractScreenComponent)new ScreenComponentGeneric((ITexture)ScreenComponentProgress.ProgressTextures.ARROW_RIGHT_OFF, 77, 38));
        this.addComponent((AbstractScreenComponent)new ScreenComponentTemperature(() -> {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            TileFissionReactorCore core = (TileFissionReactorCore)((ContainerFissionReactorCore)this.menu).getSafeHost();
            if (core == null) {
                return list;
            }
            list.add(NuclearTextUtils.tooltip("fissionreactor.maxtemp", ChatFormatter.getChatDisplayShort((double)TileFissionReactorCore.getActualTemp(5611.0), (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})).withStyle(ChatFormatting.GRAY).getVisualOrderText());
            MutableComponent text = ChatFormatter.getChatDisplayShort((double)TileFissionReactorCore.getActualTemp((Double)core.temperature.getValue()), (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS);
            text = (Double)core.temperature.getValue() > 5611.0 ? text.withStyle(ChatFormatting.RED) : ((Double)core.temperature.getValue() > 5511.0 ? text.withStyle(ChatFormatting.YELLOW) : text.withStyle(ChatFormatting.GREEN));
            list.add(NuclearTextUtils.tooltip("fissionreactor.currtemp", text).withStyle(ChatFormatting.GRAY).getVisualOrderText());
            if ((Double)core.temperature.getValue() > 5611.0 && System.currentTimeMillis() % 1000L < 500L) {
                list.add(NuclearTextUtils.tooltip("fissionreactor.warning", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}).getVisualOrderText());
            }
            return list;
        }, -25, 2));
        new WrapperInventoryIO((GenericScreen)this, -25, 28, 75, 92, 8, 82);
    }
}

