/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import nuclearscience.common.inventory.container.ContainerMSReactorCore;
import nuclearscience.common.tile.reactor.moltensalt.TileFreezePlug;
import nuclearscience.common.tile.reactor.moltensalt.TileMSReactorCore;
import nuclearscience.prefab.screen.component.ScreenComponentReactorFuel;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentMultiLabel;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentTemperature;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;

public class ScreenMSReactorCore
extends GenericScreen<ContainerMSReactorCore> {
    public static final Color WARNING_COLOR = new Color(255, 0, 0, 255);

    public ScreenMSReactorCore(ContainerMSReactorCore container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.addComponent((AbstractScreenComponent)new ScreenComponentTemperature(() -> {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            TileMSReactorCore core = (TileMSReactorCore)((ContainerMSReactorCore)this.menu).getSafeHost();
            if (core == null) {
                return list;
            }
            MutableComponent text = ChatFormatter.getChatDisplayShort((double)((Double)core.temperature.getValue()), (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS);
            text = (Double)core.temperature.getValue() > 1000.0 ? text.withStyle(ChatFormatting.RED) : ((Double)core.temperature.getValue() > 900.0 ? text.withStyle(ChatFormatting.YELLOW) : text.withStyle(ChatFormatting.GREEN));
            list.add(text.getVisualOrderText());
            return list;
        }, -25, 2));
        this.addComponent((AbstractScreenComponent)new ScreenComponentMultiLabel(0, 0, graphics -> {
            TileMSReactorCore core = (TileMSReactorCore)((ContainerMSReactorCore)this.menu).getSafeHost();
            if (core == null) {
                return;
            }
            graphics.drawString(this.font, (Component)NuclearTextUtils.gui("msreactor.status", new Object[0]), this.titleLabelX, this.titleLabelY + 14, Color.BLACK.color(), false);
            if (!(core.clientPlugCache.getSafe() instanceof TileFreezePlug)) {
                graphics.drawString(this.font, (Component)NuclearTextUtils.gui("msreactor.status.nofreezeplug", new Object[0]), this.titleLabelX + 5, this.titleLabelY + 24, Color.TEXT_GRAY.color(), false);
            } else if (((Boolean)core.wasteIsFull.getValue()).booleanValue()) {
                graphics.drawString(this.font, (Component)NuclearTextUtils.gui("msreactor.status.wastefull", new Object[0]), this.titleLabelX + 5, this.titleLabelY + 24, Color.TEXT_GRAY.color(), false);
            } else {
                graphics.drawString(this.font, (Component)NuclearTextUtils.gui("msreactor.status.good", new Object[0]).withStyle(ChatFormatting.GREEN), this.titleLabelX + 5, this.titleLabelY + 24, Color.WHITE.color(), false);
            }
            graphics.drawString(this.font, (Component)NuclearTextUtils.gui("msreactor.warning", new Object[0]), this.titleLabelX, this.titleLabelY + 38, 0, false);
            if ((Double)core.temperature.getValue() > 1000.0) {
                if (System.currentTimeMillis() % 1000L < 500L) {
                    graphics.drawString(this.font, (Component)NuclearTextUtils.gui("msreactor.warning.overheat", new Object[0]), this.titleLabelX + 5, this.titleLabelY + 48, WARNING_COLOR.color(), false);
                } else {
                    graphics.drawString(this.font, (Component)NuclearTextUtils.gui("msreactor.warning.overheat", new Object[0]), this.titleLabelX + 5, this.titleLabelY + 48, Color.TEXT_GRAY.color(), false);
                }
            } else {
                TileFreezePlug plug;
                Object patt0$temp = core.clientPlugCache.getSafe();
                if (patt0$temp instanceof TileFreezePlug && !(plug = (TileFreezePlug)((Object)((Object)patt0$temp))).isFrozen()) {
                    graphics.drawString(this.font, (Component)NuclearTextUtils.gui("msreactor.warning.freezeoff", new Object[0]).withStyle(ChatFormatting.YELLOW), this.titleLabelX + 5, this.titleLabelY + 48, Color.WHITE.color(), false);
                } else {
                    graphics.drawString(this.font, (Component)NuclearTextUtils.gui("msreactor.warning.none", new Object[0]).withStyle(ChatFormatting.GREEN), this.titleLabelX + 5, this.titleLabelY + 48, Color.WHITE.color(), false);
                }
            }
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentReactorFuel(140, 20));
    }
}

