/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import nuclearscience.common.entity.EntityParticle;
import nuclearscience.common.inventory.container.ContainerParticleInjector;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.common.tile.accelerator.TileElectromagneticGateway;
import nuclearscience.common.tile.accelerator.TileParticleInjector;
import nuclearscience.compatibility.jei.utils.NuclearJeiTextures;
import nuclearscience.prefab.screen.component.NuclearArrows;
import nuclearscience.prefab.screen.component.NuclearIconTypes;
import nuclearscience.prefab.utils.NuclearDisplayUnits;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.types.wrapper.WrapperInventoryIO;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.math.Color;

public class ScreenParticleInjector
extends GenericScreen<ContainerParticleInjector> {
    public ScreenParticleInjector(ContainerParticleInjector container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.imageHeight += 10;
        this.inventoryLabelY += 10;
        this.addComponent((AbstractScreenComponent)new ScreenComponentGeneric((ITexture)NuclearArrows.PARTICLE_INJECTOR_ARROWS, 44, 24));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(this.titleLabelX, this.titleLabelY + 20, 10, Color.TEXT_GRAY, (Component)NuclearTextUtils.gui("particleinjector.matter", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(this.titleLabelX, this.titleLabelY + 56, 10, Color.TEXT_GRAY, (Component)NuclearTextUtils.gui("particleinjector.cells", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getElectricInformation, -25, 2).wattage(((Double)NuclearConfig.INSTANCE.PARTICLEINJECTOR_USAGE_PER_PARTICLE.get()).doubleValue()));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, -25, 54).setOnPress(button -> {
            TileParticleInjector injector = (TileParticleInjector)((ContainerParticleInjector)this.menu).getSafeHost();
            if (injector == null) {
                return;
            }
            injector.usingGateway.setValue((Object)((Boolean)injector.usingGateway.getValue() == false ? 1 : 0));
        }).setIcon((ITexture)NuclearIconTypes.GATEWAY).onTooltip((graphics, button, x, y) -> {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            TileParticleInjector injector = (TileParticleInjector)((ContainerParticleInjector)this.menu).getSafeHost();
            if (injector == null) {
                return;
            }
            list.add(NuclearTextUtils.tooltip("particleinjector.gatewaymode", new Object[0]).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
            if (((Boolean)injector.usingGateway.getValue()).booleanValue()) {
                list.add(NuclearTextUtils.tooltip("particleinjector.gatewayenabled", new Object[0]).withStyle(ChatFormatting.GREEN).getVisualOrderText());
            } else {
                list.add(NuclearTextUtils.tooltip("particleinjector.gatewaydisabled", new Object[0]).withStyle(ChatFormatting.RED).getVisualOrderText());
            }
            graphics.renderTooltip(this.getFontRenderer(), list, x, y);
        }));
        new WrapperInventoryIO((GenericScreen)this, -25, 28, 75, 82, 8, 72);
        this.addComponent((AbstractScreenComponent)new ScreenComponentGeneric((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR_RIGHT, this.imageWidth - 1, 2).setIcon((ITexture)NuclearJeiTextures.PARTICLEACCELERATOR_DMATOM).onTooltip((graphics, component, x, y) -> {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            TileParticleInjector injector = (TileParticleInjector)((ContainerParticleInjector)this.menu).getSafeHost();
            if (injector == null) {
                return;
            }
            EntityParticle one = injector.particles[0];
            float oneSpeed = 0.0f;
            if (one != null && one.isAlive() && !one.isRemoved()) {
                oneSpeed = one.speed;
            }
            list.add(NuclearTextUtils.tooltip("particleinjector.particle1speed", ChatFormatter.getChatDisplayShort((double)TileElectromagneticGateway.getLightSpeedPerc(oneSpeed), (IDisplayUnit)DisplayUnits.PERCENTAGE).append(" ").append(NuclearDisplayUnits.SPEEDOFLIGHT.getSymbol()).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
            EntityParticle two = injector.particles[1];
            float twoSpeed = 0.0f;
            if (two != null && two.isAlive() && !two.isRemoved()) {
                twoSpeed = two.speed;
            }
            list.add(NuclearTextUtils.tooltip("particleinjector.particle2speed", ChatFormatter.getChatDisplayShort((double)TileElectromagneticGateway.getLightSpeedPerc(twoSpeed), (IDisplayUnit)DisplayUnits.PERCENTAGE).append(" ").append(NuclearDisplayUnits.SPEEDOFLIGHT.getSymbol()).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
            graphics.renderTooltip(this.getFontRenderer(), list, x, y);
        }));
    }

    private List<? extends FormattedCharSequence> getElectricInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileParticleInjector injector = (TileParticleInjector)((ContainerParticleInjector)this.menu).getSafeHost();
        if (injector == null) {
            return list;
        }
        ComponentElectrodynamic el = (ComponentElectrodynamic)injector.getComponent(IComponentType.Electrodynamic);
        list.add(NuclearTextUtils.tooltip("particleinjector.charge", ChatFormatter.getChatDisplayShort((double)el.getJoulesStored(), (IDisplayUnit)DisplayUnits.JOULES).withStyle(ChatFormatting.GRAY), ChatFormatter.getChatDisplayShort((double)((Double)NuclearConfig.INSTANCE.PARTICLEINJECTOR_USAGE_PER_PARTICLE.get()), (IDisplayUnit)DisplayUnits.JOULES).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
        list.add(ElectroTextUtils.gui((String)"machine.voltage", (Object[])new Object[]{ChatFormatter.getChatDisplayShort((double)el.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
        return list;
    }
}

