/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import nuclearscience.common.block.states.NuclearScienceBlockStates;
import nuclearscience.common.block.states.facing.FacingDirection;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.tile.IWrenchable;

public class BlockElectromagneticBooster
extends Block
implements IWrenchable {
    public BlockElectromagneticBooster() {
        super(Blocks.GLASS.properties().strength(3.5f, 20.0f).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((x, y, z) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH)).setValue((Property)NuclearScienceBlockStates.FACINGDIRECTION, (Comparable)((Object)FacingDirection.NONE)));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)VoltaicBlockStates.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)VoltaicBlockStates.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)VoltaicBlockStates.FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction movingdirection = context.getHorizontalDirection();
        BlockState state = (BlockState)super.getStateForPlacement(context).setValue((Property)VoltaicBlockStates.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        BlockState check = context.getLevel().getBlockState(context.getClickedPos().relative(movingdirection.getClockWise().getOpposite()));
        if (check.getBlock() == this && ((Direction)check.getValue((Property)VoltaicBlockStates.FACING)).getOpposite() == movingdirection.getClockWise().getOpposite()) {
            state = (BlockState)state.setValue((Property)NuclearScienceBlockStates.FACINGDIRECTION, (Comparable)((Object)FacingDirection.LEFT));
        } else {
            check = context.getLevel().getBlockState(context.getClickedPos().relative(movingdirection.getClockWise()));
            if (check.getBlock() == this && ((Direction)check.getValue((Property)VoltaicBlockStates.FACING)).getOpposite() == movingdirection.getClockWise()) {
                state = (BlockState)state.setValue((Property)NuclearScienceBlockStates.FACINGDIRECTION, (Comparable)((Object)FacingDirection.RIGHT));
            }
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VoltaicBlockStates.FACING});
        builder.add(new Property[]{NuclearScienceBlockStates.FACINGDIRECTION});
    }

    public void onRotate(ItemStack stack, BlockPos pos, Player player) {
        player.level().setBlockAndUpdate(pos, this.rotate(player.level().getBlockState(pos), Rotation.CLOCKWISE_90));
    }

    public void onPickup(ItemStack stack, BlockPos pos, Player player) {
        Level world = player.level();
        BlockState current = world.getBlockState(pos);
        FacingDirection face = (FacingDirection)((Object)current.getValue((Property)NuclearScienceBlockStates.FACINGDIRECTION));
        if (face != FacingDirection.NONE) {
            current = (BlockState)current.setValue((Property)NuclearScienceBlockStates.FACINGDIRECTION, (Comparable)((Object)(face == FacingDirection.LEFT ? FacingDirection.RIGHT : FacingDirection.LEFT)));
            if (face == FacingDirection.RIGHT) {
                current = this.rotate(current, Rotation.CLOCKWISE_180);
            }
            current = this.rotate(current, Rotation.CLOCKWISE_90);
        } else {
            current = this.rotate(current, Rotation.CLOCKWISE_180);
        }
        world.setBlockAndUpdate(pos, current);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }
}

