/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.tile.IWrenchable;

public class BlockElectromagneticDiode
extends Block
implements IWrenchable {
    private static final VoxelShape SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);

    public BlockElectromagneticDiode() {
        super(Blocks.IRON_BLOCK.properties().strength(3.5f, 20.0f).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((p1, p2, p3) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)VoltaicBlockStates.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)VoltaicBlockStates.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)VoltaicBlockStates.FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)VoltaicBlockStates.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VoltaicBlockStates.FACING});
    }

    public void onRotate(ItemStack stack, BlockPos pos, Player player) {
        player.level().setBlockAndUpdate(pos, this.rotate(player.level().getBlockState(pos), Rotation.CLOCKWISE_90));
    }

    public void onPickup(ItemStack stack, BlockPos pos, Player player) {
        Level world = player.level();
        world.destroyBlock(pos, true, (Entity)player);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

