/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.util.IRadiationRecipient;
import voltaic.registers.VoltaicCapabilities;

public class BlockRadioactiveAir
extends AirBlock {
    public BlockRadioactiveAir() {
        super(Blocks.AIR.properties().noCollission().air().randomTicks());
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        RadiationSystem.removeRadiationSource((Level)level, (BlockPos)pos, (boolean)true);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.getLevelData().getGameTime() % 10L == 0L && !level.isClientSide && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            IRadiationRecipient cap = (IRadiationRecipient)living.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONRECIPIENT);
            if (cap == null) {
                return;
            }
            cap.recieveRadiation(living, 20.0, 1.0);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        if (random.nextFloat() < 0.01f) {
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }
}

