/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.item;

import java.util.EnumMap;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import nuclearscience.NuclearScience;
import org.jetbrains.annotations.Nullable;
import voltaic.api.radiation.util.IHazmatSuit;
import voltaic.common.item.gear.ItemVoltaicArmor;

public class ItemHazmatArmor
extends ItemVoltaicArmor
implements IHazmatSuit {
    public static final EnumMap<ArmorItem.Type, Integer> DEFENSE_MAP_BASE = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.HELMET, 2);
        map.put(ArmorItem.Type.CHESTPLATE, 2);
        map.put(ArmorItem.Type.LEGGINGS, 2);
        map.put(ArmorItem.Type.BOOTS, 2);
    });
    public static final EnumMap<ArmorItem.Type, Integer> DEFENSE_MAP_REINFORCED = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.HELMET, 4);
        map.put(ArmorItem.Type.CHESTPLATE, 4);
        map.put(ArmorItem.Type.LEGGINGS, 4);
        map.put(ArmorItem.Type.BOOTS, 4);
    });
    private final double radiationProtection;
    private final double radiationStrengthProtection;
    private final ResourceLocation armorTexture;

    public ItemHazmatArmor(Holder<ArmorMaterial> materialIn, ArmorItem.Type slot, Item.Properties properties, Holder<CreativeModeTab> creativeTab, double radiationProtection, double radiationStrengthRating, String armorTexture) {
        super(materialIn, slot, properties, creativeTab);
        this.radiationProtection = radiationProtection;
        this.radiationStrengthProtection = radiationStrengthRating;
        this.armorTexture = NuclearScience.rl("textures/models/armor/" + armorTexture + ".png");
    }

    public double getRadResistance() {
        return this.radiationProtection;
    }

    public double getRadStrengthProtection() {
        return this.radiationStrengthProtection;
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return this.armorTexture;
    }
}

