/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import nuclearscience.common.block.subtype.SubtypeReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileControlRodModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileController;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileMonitorModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileSupplyModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileThermometerModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import voltaic.api.network.ITickableNetwork;
import voltaic.common.network.NetworkRegistry;
import voltaic.prefab.network.AbstractNetwork;

public class ReactorLogisticsNetwork
extends AbstractNetwork<TileReactorLogisticsCable, SubtypeReactorLogisticsCable, Void, ReactorLogisticsNetwork> {
    private TileController controller;
    private final HashMap<BlockPos, TileControlRodModule> controlRods = new HashMap();
    private final HashMap<BlockPos, TileSupplyModule> supplyModules = new HashMap();
    private final HashMap<BlockPos, GenericTileInterface> interfaces = new HashMap();
    private final HashMap<BlockPos, TileMonitorModule> monitors = new HashMap();
    private final HashMap<BlockPos, TileThermometerModule> thermometers = new HashMap();

    public ReactorLogisticsNetwork(Collection<TileReactorLogisticsCable> varCables) {
        this.conductorSet.addAll(varCables);
        NetworkRegistry.register((ITickableNetwork)this);
    }

    public ReactorLogisticsNetwork(Set<ReactorLogisticsNetwork> networks) {
        for (ReactorLogisticsNetwork net : networks) {
            if (net == null) continue;
            this.conductorSet.addAll(net.conductorSet);
            net.deregister();
        }
        NetworkRegistry.register((ITickableNetwork)this);
    }

    public void refreshNewNetwork() {
        this.controller = null;
        this.interfaces.clear();
        this.controlRods.clear();
        this.supplyModules.clear();
        this.monitors.clear();
        this.thermometers.clear();
        super.refreshNewNetwork();
    }

    public void resetReceiverStatistics() {
        super.resetReceiverStatistics();
        this.controller = null;
        this.interfaces.clear();
        this.controlRods.clear();
        this.supplyModules.clear();
        this.monitors.clear();
        this.thermometers.clear();
    }

    public void tick() {
        for (BlockEntity tile : this.acceptorSet) {
            if (tile != null && !tile.isRemoved()) continue;
            this.acceptorSet.remove(tile);
            this.acceptorInputMap.remove(tile);
        }
    }

    public void updateRecieverStatistics(BlockEntity reciever, Direction dir) {
        if (reciever instanceof TileController) {
            TileController controller;
            this.controller = controller = (TileController)reciever;
        } else if (reciever instanceof GenericTileInterface) {
            GenericTileInterface reactorInterface = (GenericTileInterface)reciever;
            this.interfaces.put(reactorInterface.getBlockPos(), reactorInterface);
        } else if (reciever instanceof TileControlRodModule) {
            TileControlRodModule controlRod = (TileControlRodModule)reciever;
            this.controlRods.put(controlRod.getBlockPos(), controlRod);
        } else if (reciever instanceof TileSupplyModule) {
            TileSupplyModule supplyModule = (TileSupplyModule)reciever;
            this.supplyModules.put(supplyModule.getBlockPos(), supplyModule);
        } else if (reciever instanceof TileMonitorModule) {
            TileMonitorModule monitor = (TileMonitorModule)reciever;
            this.monitors.put(monitor.getBlockPos(), monitor);
        } else if (reciever instanceof TileThermometerModule) {
            TileThermometerModule thermometer = (TileThermometerModule)reciever;
            this.thermometers.put(thermometer.getBlockPos(), thermometer);
        }
    }

    public Void emit(Void transfer, ArrayList<BlockEntity> ignored, boolean debug) {
        throw new UnsupportedOperationException("The Reactor Logistics Network does not emit, what are you doing?");
    }

    public boolean isConductor(BlockEntity blockEntity, TileReactorLogisticsCable iReactorLogisticsCable) {
        return blockEntity instanceof TileReactorLogisticsCable;
    }

    public ReactorLogisticsNetwork createInstanceConductor(Set<TileReactorLogisticsCable> set) {
        return new ReactorLogisticsNetwork((Collection<TileReactorLogisticsCable>)set);
    }

    @Nullable
    public TileController getController() {
        return this.controller;
    }

    @Nullable
    public TileControlRodModule getControlRod(BlockPos pos) {
        return this.controlRods.getOrDefault(pos, null);
    }

    @Nullable
    public TileSupplyModule getSupplyModule(BlockPos pos) {
        return this.supplyModules.getOrDefault(pos, null);
    }

    @Nullable
    public GenericTileInterface getInterface(BlockPos pos) {
        return this.interfaces.getOrDefault(pos, null);
    }

    public List<GenericTileInterface> getInterfacesForType(GenericTileInterface.InterfaceType ... types) {
        ArrayList<GenericTileInterface> interfaces = new ArrayList<GenericTileInterface>();
        this.interfaces.forEach((pos, tile) -> {
            for (GenericTileInterface.InterfaceType type : types) {
                if (tile.getInterfaceType() != type) continue;
                interfaces.add((GenericTileInterface)tile);
            }
        });
        return interfaces;
    }

    public boolean isControllerActive() {
        return this.controller != null && this.controller.isActive();
    }
}

