/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import nuclearscience.common.inventory.container.ContainerAtomicAssembler;
import nuclearscience.common.reloadlistener.AtomicAssemblerBlacklistRegister;
import nuclearscience.common.reloadlistener.AtomicAssemblerWhitelistRegister;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.ItemUtils;
import voltaic.prefab.utilities.RadiationUtils;

public class TileAtomicAssembler
extends GenericTile {
    public final SingleProperty<Integer> progress = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "progress", (Object)0));

    public TileAtomicAssembler(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_ATOMICASSEMBLER.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickCommon(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).maxJoules((Double)NuclearConfig.INSTANCE.ATOMICASSEMBLER_USAGE_PER_TICK.get() * 20.0).voltage(((Double)NuclearConfig.INSTANCE.ATOMICASSEMBLER_VOLTAGE.get()).doubleValue()).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(7).outputs(1)).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0, 1, 2, 3, 4, 5}).setDirectionsBySlot(Integer.valueOf(6), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.RIGHT, BlockEntityUtils.MachineDirection.BACK}).setDirectionsBySlot(Integer.valueOf(7), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.FRONT}).valid((slot, stack, i) -> slot == 6 || slot < 6 && stack.is((Item)NuclearScienceItems.ITEM_CELLDARKMATTER.get())));
        this.addComponent((IComponent)new ComponentContainerProvider("atomicassembler", (GenericTile)this).createMenu((id, player) -> new ContainerAtomicAssembler((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    private void tickServer(ComponentTickable tickable) {
        boolean validItem;
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)inv, (int)((Integer)NuclearConfig.INSTANCE.ATOMIC_ASSEMBLER_RADIATION_RADIUS.get()), (boolean)true, (int)30, (boolean)true, (boolean)false);
        ItemStack input = inv.getItem(6);
        if (input.isEmpty()) {
            this.progress.setValue((Object)0);
            return;
        }
        ItemStack output = inv.getItem(7);
        boolean bl = validItem = TileAtomicAssembler.validateDupeItem(input) && (output.isEmpty() || ItemStack.isSameItem((ItemStack)input, (ItemStack)output) && output.getCount() + 1 <= output.getMaxStackSize());
        if (!validItem) {
            this.progress.setValue((Object)0);
            return;
        }
        for (int index = 0; index < 6; ++index) {
            ItemStack dmCell = inv.getItem(index);
            if (dmCell.isEmpty() || dmCell.getItem() != NuclearScienceItems.ITEM_CELLDARKMATTER.get()) {
                this.progress.setValue((Object)0);
                return;
            }
            if (dmCell.getDamageValue() < dmCell.getMaxDamage()) continue;
            this.progress.setValue((Object)0);
            inv.setItem(index, ItemStack.EMPTY);
            return;
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < (Double)NuclearConfig.INSTANCE.ATOMICASSEMBLER_USAGE_PER_TICK.get()) {
            return;
        }
        this.progress.setValue((Object)((Integer)this.progress.getValue() + 1));
        electro.joules(electro.getJoulesStored() - (Double)NuclearConfig.INSTANCE.ATOMICASSEMBLER_USAGE_PER_TICK.get());
        if ((Integer)this.progress.getValue() < (Integer)NuclearConfig.INSTANCE.ATOMICASSEMBLER_REQUIRED_TICKS.get()) {
            return;
        }
        this.progress.setValue((Object)0);
        for (int index = 0; index < 6; ++index) {
            ItemStack dmCell = inv.getItem(index);
            dmCell.setDamageValue(dmCell.getDamageValue() + 1);
            if (dmCell.getDamageValue() < dmCell.getMaxDamage()) continue;
            inv.setItem(index, ItemStack.EMPTY);
        }
        if (output.isEmpty()) {
            inv.setItem(7, new ItemStack((ItemLike)input.getItem()));
        } else {
            output.setCount(output.getCount() + 1);
        }
    }

    private static boolean validateDupeItem(ItemStack stack) {
        if (AtomicAssemblerWhitelistRegister.INSTANCE.isWhitelist(stack.getItem())) {
            return true;
        }
        if (AtomicAssemblerBlacklistRegister.INSTANCE.isBlacklisted(stack.getItem())) {
            return false;
        }
        if (stack.has(DataComponents.CONTAINER)) {
            return false;
        }
        return !ItemUtils.testItems((Item)stack.getItem(), (Item[])new Item[]{(Item)NuclearScienceItems.ITEM_CELLDARKMATTER.get()}) || stack.getCapability(Capabilities.ItemHandler.ITEM) == null;
    }
}

