/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.inventory.container.ContainerGasCentrifuge;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceSounds;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.PropertyGasTank;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentGasHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;
import voltaic.registers.VoltaicGases;

public class TileGasCentrifuge
extends GenericTile
implements ITickableSound {
    public static final int TANKCAPACITY = 5000;
    public static final double REQUIRED = 2500.0;
    public static final double PERCENT_U235 = 0.172;
    public static final int MAX_TEMPERATURE = 350;
    public static final double WASTE_MULTIPLIER = 0.1;
    public SingleProperty<Integer> spinSpeed = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "spinSpeed", (Object)0));
    public SingleProperty<Double> stored235 = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "stored235", (Object)0.0));
    public SingleProperty<Double> stored238 = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "stored238", (Object)0.0));
    public SingleProperty<Double> storedWaste = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "storedWaste", (Object)0.0));
    public SingleProperty<Boolean> isRunning = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isRunning", (Object)false));
    private boolean isSoundPlaying = false;

    public TileGasCentrifuge(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_GASCENTRIFUGE.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentGasHandlerMulti((GenericTile)this).setInputTanks(1, TileGasCentrifuge.arr((int[])new int[]{5000}), TileGasCentrifuge.arr((int[])new int[]{350}), TileGasCentrifuge.arr((int[])new int[]{1})).setInputGasTags(new TagKey[]{NuclearScienceTags.Gases.URANIUM_HEXAFLUORIDE}).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(240.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).maxJoules((Double)NuclearConfig.INSTANCE.GASCENTRIFUGE_USAGE_PER_TICK.get() * 10.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().outputs(3).upgrades(3)).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0, 1, 2}).setSlotsByDirection(BlockEntityUtils.MachineDirection.RIGHT, new Integer[]{0, 1, 2}).setSlotsByDirection(BlockEntityUtils.MachineDirection.LEFT, new Integer[]{0, 1, 2}).setSlotsByDirection(BlockEntityUtils.MachineDirection.BACK, new Integer[]{0, 1, 2}).validUpgrades(ContainerGasCentrifuge.VALID_UPGRADES).valid(TileGasCentrifuge.machineValidator()));
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this).usage(((Double)NuclearConfig.INSTANCE.GASCENTRIFUGE_USAGE_PER_TICK.get()).doubleValue(), 0).requiredTicks((long)((Integer)NuclearConfig.INSTANCE.GASCENTRIFUGE_REQUIRED_TICKS_PER_PROCESSING.get()).intValue(), 0).canProcess(this::canProcess).process(this::process));
        this.addComponent((IComponent)new ComponentContainerProvider("gascentrifuge", (GenericTile)this).createMenu((id, player) -> new ContainerGasCentrifuge((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public boolean canProcess(ComponentProcessor processor, int procNumber) {
        boolean val;
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        RadiationUtils.handleRadioactiveGases((GenericTile)this, (ComponentGasHandlerMulti)gasHandler, (int)((Integer)NuclearConfig.INSTANCE.GAS_CENTRIFUGE_RADIATION_RADIUS.get()), (boolean)true, (int)30, (boolean)true, (boolean)false);
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)inv, (int)((Integer)NuclearConfig.INSTANCE.GAS_CENTRIFUGE_RADIATION_RADIUS.get()), (boolean)true, (int)30, (boolean)true, (boolean)false);
        boolean hasGas = (double)gasHandler.getInputTanks()[0].getGasAmount() >= 41.666666666666664;
        boolean bl = val = electro.getJoulesStored() >= processor.getUsage(0) && hasGas && inv.getItem(0).getCount() < inv.getItem(0).getMaxStackSize() && inv.getItem(1).getCount() < inv.getItem(1).getMaxStackSize() && inv.getItem(2).getCount() < inv.getItem(2).getMaxStackSize();
        if (!val && (Integer)this.spinSpeed.getValue() > 0) {
            this.spinSpeed.setValue((Object)0);
        }
        this.isRunning.setValue((Object)val);
        return val;
    }

    public void process(ComponentProcessor processor, int procNumber) {
        ItemStack stack;
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ComponentGasHandlerMulti multi = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        this.spinSpeed.setValue((Object)((Double)processor.operatingSpeed.getValue()).intValue());
        int processed = 41;
        PropertyGasTank tank = multi.getInputTanks()[0];
        if (((HolderSet.Named)VoltaicGases.GAS_REGISTRY.getTag(NuclearScienceTags.Gases.URANIUM_HEXAFLUORIDE).get()).contains(tank.getGas().getGasHolder()) && tank.getGasAmount() >= processed) {
            tank.drain(processed, GasAction.EXECUTE);
        }
        this.stored235.setValue((Object)((Double)this.stored235.getValue() + (double)processed * 0.172));
        this.stored238.setValue((Object)((Double)this.stored238.getValue() + (double)processed * 0.7280000000000001));
        this.storedWaste.setValue((Object)((Double)this.stored235.getValue() + (double)processed * 0.1));
        if ((Double)this.stored235.getValue() > 2500.0) {
            stack = inv.getItem(0);
            if (!stack.isEmpty()) {
                stack.setCount(stack.getCount() + 1);
            } else {
                inv.setItem(0, new ItemStack((ItemLike)NuclearScienceItems.ITEM_URANIUM235.get()));
            }
            this.stored235.setValue((Object)((Double)this.stored235.getValue() - 2500.0));
        }
        if ((Double)this.stored238.getValue() > 2500.0) {
            stack = inv.getItem(1);
            if (!stack.isEmpty()) {
                stack.setCount(stack.getCount() + 1);
            } else {
                inv.setItem(1, new ItemStack((ItemLike)NuclearScienceItems.ITEM_URANIUM238.get()));
            }
            this.stored238.setValue((Object)((Double)this.stored238.getValue() - 2500.0));
        }
        if ((Double)this.storedWaste.getValue() > 2500.0) {
            stack = inv.getItem(2);
            if (!stack.isEmpty()) {
                stack.grow(1);
            } else {
                inv.setItem(2, new ItemStack((ItemLike)NuclearScienceItems.ITEM_FISSILEDUST.get(), 1));
            }
            this.storedWaste.setValue((Object)((Double)this.storedWaste.getValue() - 2500.0));
        }
    }

    protected void tickClient(ComponentTickable tickable) {
        if (!this.isSoundPlaying && this.shouldPlaySound()) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)NuclearScienceSounds.SOUND_GASCENTRIFUGE.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Integer)this.spinSpeed.getValue() > 0;
    }

    public int getComparatorSignal() {
        return (Boolean)this.isRunning.getValue() != false ? 15 : 0;
    }
}

