/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.utilities.ElectricityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.inventory.container.ContainerRadioisotopeGenerator;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.common.reloadlistener.RadioactiveItemRegister;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileRadioisotopeGenerator
extends GenericTile {
    protected CachedTileOutput output1;
    protected CachedTileOutput output2;

    public TileRadioisotopeGenerator(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_RADIOISOTOPEGENERATOR.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, false).voltage(((Double)NuclearConfig.INSTANCE.RADIOISOTOPEGENERATOR_VOLTAGE.get()).doubleValue()).extractPower((x, y) -> TransferPack.EMPTY).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.TOP}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1)).setDirectionsBySlot(Integer.valueOf(0), BlockEntityUtils.MachineDirection.values()).valid((slot, stack, i) -> RadioactiveItemRegister.getValue((Item)stack.getItem()).amount() > 0.0));
        this.addComponent((IComponent)new ComponentContainerProvider("radioisotopegenerator", (GenericTile)this).createMenu((id, player) -> new ContainerRadioisotopeGenerator((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tickable) {
        ComponentInventory inv;
        ItemStack input;
        if (this.output1 == null) {
            this.output1 = new CachedTileOutput(this.level, this.worldPosition.relative(Direction.UP));
        }
        if (this.output2 == null) {
            this.output2 = new CachedTileOutput(this.level, this.worldPosition.relative(Direction.DOWN));
        }
        if (tickable.getTicks() % 40L == 0L) {
            this.output1.update(this.worldPosition.relative(Direction.UP));
            this.output2.update(this.worldPosition.relative(Direction.DOWN));
        }
        if ((input = (inv = (ComponentInventory)this.getComponent(IComponentType.Inventory)).getItem(0)).isEmpty()) {
            return;
        }
        RadioactiveObject radiation = RadioactiveItemRegister.getValue((Item)input.getItem());
        if (radiation.amount() <= 0.0) {
            return;
        }
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)inv, (int)((Integer)NuclearConfig.INSTANCE.RADIO_GENATOR_RADIATION_RADIUS.get()), (boolean)true, (int)30, (boolean)true, (boolean)false);
        double currentOutput = (double)input.getCount() * (Double)NuclearConfig.INSTANCE.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER.get() * radiation.amount();
        if (currentOutput > 0.0) {
            TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / ((Double)NuclearConfig.INSTANCE.RADIOISOTOPEGENERATOR_VOLTAGE.get() * 2.0)), (double)((Double)NuclearConfig.INSTANCE.RADIOISOTOPEGENERATOR_VOLTAGE.get()));
            if (this.output1.valid()) {
                ElectricityUtils.receivePower((BlockEntity)((BlockEntity)this.output1.getSafe()), (Direction)Direction.DOWN, (TransferPack)transfer, (boolean)false);
            }
            if (this.output2.valid()) {
                ElectricityUtils.receivePower((BlockEntity)((BlockEntity)this.output2.getSafe()), (Direction)Direction.UP, (TransferPack)transfer, (boolean)false);
            }
        }
    }

    public int getComparatorSignal() {
        ItemStack stack = ((ComponentInventory)this.getComponent(IComponentType.Inventory)).getItem(0);
        if (stack.isEmpty()) {
            return 0;
        }
        return (int)((double)stack.getCount() / (double)stack.getMaxStackSize() * 15.0);
    }
}

