/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import nuclearscience.common.inventory.container.ContainerTeleporter;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileTeleporter
extends GenericTile {
    public final SingleProperty<BlockPos> destination = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "location", (Object)this.getBlockPos()));
    public final SingleProperty<Integer> cooldown = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "cooldown", (Object)0));
    public final SingleProperty<ResourceLocation> dimension = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.RESOURCE_LOCATION, "dimension", (Object)Level.OVERWORLD.location()));

    public TileTeleporter(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_TELEPORTER.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).maxJoules((Double)NuclearConfig.INSTANCE.TELEPORTER_USAGE_PER_TELEPORT.get() * 20.0).voltage(480.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1)));
        this.addComponent((IComponent)new ComponentContainerProvider("teleporter", (GenericTile)this).createMenu((id, player) -> new ContainerTeleporter((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected void tickServer(ComponentTickable tickable) {
        boolean powered;
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        boolean bl = powered = electro.getJoulesStored() > (Double)NuclearConfig.INSTANCE.TELEPORTER_USAGE_PER_TELEPORT.get();
        if (BlockEntityUtils.isLit((GenericTile)this) ^ powered) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)powered);
        }
        if (((BlockPos)this.destination.getValue()).equals((Object)this.getBlockPos()) || electro.getJoulesStored() < electro.getMaxJoulesStored()) {
            return;
        }
        if ((Integer)this.cooldown.getValue() > 0) {
            this.cooldown.setValue((Object)((Integer)this.cooldown.getValue() - 1));
            return;
        }
        AABB entityCheckArea = AABB.encapsulatingFullBlocks((BlockPos)this.getBlockPos(), (BlockPos)this.getBlockPos().offset(1, 2, 1));
        List players = this.getLevel().getEntities((EntityTypeTest)EntityType.PLAYER, entityCheckArea, en -> true);
        if (players.isEmpty()) {
            this.cooldown.setValue((Object)5);
            return;
        }
        ServerLevel destinationLevel = this.getDestinationLevel();
        Player player = (Player)players.get(0);
        BlockPos destPos = (BlockPos)this.destination.getValue();
        player.changeDimension(new DimensionTransition(destinationLevel, new Vec3((double)destPos.getX(), (double)destPos.getY(), (double)destPos.getZ()), Vec3.ZERO, player.getXRot(), player.getYRot(), false, DimensionTransition.PLACE_PORTAL_TICKET));
        this.cooldown.setValue((Object)80);
        electro.joules(electro.getJoulesStored() - (Double)NuclearConfig.INSTANCE.TELEPORTER_USAGE_PER_TELEPORT.get());
    }

    private ServerLevel getDestinationLevel() {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceLocation)this.dimension.getValue())));
        if (level == null) {
            return (ServerLevel)this.getLevel();
        }
        return level;
    }
}

