/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.accelerator;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.entity.EntityParticle;
import nuclearscience.common.inventory.container.ContainerParticleInjector;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.Voltaic;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;
import voltaic.prefab.utilities.object.Location;

public class TileParticleInjector
extends GenericTile {
    public static final int INPUT_SLOT = 0;
    public static final int ELECTRO_CELL_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    public final EntityParticle[] particles = new EntityParticle[2];
    public int timeSinceSpawn = 0;
    public final SingleProperty<Boolean> usingGateway = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "usinggateway", (Object)false));
    public final SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasredstonesignal", (Object)false));

    public TileParticleInjector(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_PARTICLEINJECTOR.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickCommon(this::tickCommon));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(2).outputs(1)).valid((index, stack, i) -> index != 1 || stack.getItem() == NuclearScienceItems.ITEM_CELLELECTROMAGNETIC.get()).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0, 1}).setSlotsByDirection(BlockEntityUtils.MachineDirection.RIGHT, new Integer[]{0, 1}).setDirectionsBySlot(Integer.valueOf(2), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT}));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(960.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).maxJoules(((Double)NuclearConfig.INSTANCE.PARTICLEINJECTOR_USAGE_PER_PARTICLE.get()).doubleValue()));
        this.addComponent((IComponent)new ComponentContainerProvider("particleinjector", (GenericTile)this).createMenu((id, player) -> new ContainerParticleInjector((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    private void tickCommon(ComponentTickable tickable) {
        if (this.particles[0] != null && !this.particles[0].isAlive()) {
            this.particles[0] = null;
        }
        if (this.particles[1] != null && !this.particles[1].isAlive()) {
            this.particles[1] = null;
        }
        if (this.particles[0] == null && this.particles[1] != null) {
            this.particles[0] = this.particles[1];
            this.particles[1] = null;
        }
    }

    private void tickServer(ComponentTickable componentTickable) {
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)((ComponentInventory)this.getComponent(IComponentType.Inventory)), (int)((Integer)NuclearConfig.INSTANCE.PARTICLE_INJECTOR_RADIATION_RADIUS.get()), (boolean)true, (int)30, (boolean)true, (boolean)false);
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            return;
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack input = inv.getItem(0);
        if (electro.getJoulesStored() < (Double)NuclearConfig.INSTANCE.PARTICLEINJECTOR_USAGE_PER_PARTICLE.get() || input.isEmpty()) {
            return;
        }
        if (this.timeSinceSpawn > 0) {
            --this.timeSinceSpawn;
            return;
        }
        if (((Boolean)this.usingGateway.getValue()).booleanValue() && this.particles[0] != null && !this.particles[0].passedThroughGate) {
            return;
        }
        if (!((Boolean)this.usingGateway.getValue()).booleanValue() && !this.level.getBlockState(this.worldPosition.relative(this.getFacing())).is((Block)NuclearScienceBlocks.BLOCK_ELECTORMAGNETICBOOSTER.get())) {
            return;
        }
        if (this.particles[0] != null && this.particles[1] != null) {
            return;
        }
        ItemStack resultStack = inv.getItem(2);
        if (resultStack.getCount() >= resultStack.getMaxStackSize()) {
            return;
        }
        this.timeSinceSpawn = (Integer)NuclearConfig.INSTANCE.DEFAULT_PARTICLE_COOLDOWN_TICKS.get();
        input.shrink(1);
        Direction dir = this.getFacing();
        EntityParticle particle = new EntityParticle(dir, this.level, new Location((double)((float)this.worldPosition.getX() + 0.5f + (float)dir.getStepX()), (double)((float)this.worldPosition.getY() + 0.5f + (float)dir.getStepY()), (double)((float)this.worldPosition.getZ() + 0.5f + (float)dir.getStepZ())), this.getBlockPos());
        this.addParticle(particle);
        this.level.addFreshEntity((Entity)particle);
        electro.setJoulesStored(electro.getJoulesStored() - (Double)NuclearConfig.INSTANCE.PARTICLEINJECTOR_USAGE_PER_PARTICLE.get());
    }

    public boolean handleCollision() {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack resultStack = inv.getItem(2);
        ItemStack cellStack = inv.getItem(1);
        if (this.particles[0] == null || this.particles[1] == null) {
            return false;
        }
        EntityParticle one = this.particles[0];
        EntityParticle two = this.particles[1];
        if (one.distanceTo(two) >= 1.0f) {
            return false;
        }
        BlockPos pos = one.blockPosition();
        if (!this.level.isClientSide()) {
            this.level.playSound(null, pos, SoundEvents.END_PORTAL_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
            one.remove(Entity.RemovalReason.KILLED);
            two.remove(Entity.RemovalReason.KILLED);
            Random random = Voltaic.RANDOM;
            for (int i = 0; i < 50; ++i) {
                double d0 = (double)pos.getX() + random.nextDouble();
                double d1 = (double)pos.getY() + random.nextDouble();
                double d2 = (double)pos.getZ() + random.nextDouble();
                double d3 = ((double)random.nextFloat() - 0.5) * 0.5;
                ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, 1, 0.0, 0.0, 0.0, d3);
            }
            if (!cellStack.isEmpty() && resultStack.getCount() < resultStack.getMaxStackSize() && one.speed >= 1.0f && two.speed >= 1.0f) {
                double speedOfMax = Math.pow((double)(one.speed + two.speed) / 4.0, 2.0);
                if (speedOfMax > 0.999) {
                    if (resultStack.getItem() == NuclearScienceItems.ITEM_CELLDARKMATTER.get()) {
                        resultStack.setCount(resultStack.getCount() + 1);
                        cellStack.shrink(1);
                    } else if (resultStack.isEmpty()) {
                        inv.setItem(2, new ItemStack((ItemLike)NuclearScienceItems.ITEM_CELLDARKMATTER.get()));
                        cellStack.shrink(1);
                    }
                } else if (speedOfMax > this.level.random.nextDouble()) {
                    if (resultStack.getItem() == NuclearScienceItems.ITEM_CELLANTIMATTERSMALL.get()) {
                        resultStack.setCount(resultStack.getCount() + 1);
                        cellStack.shrink(1);
                    } else if (resultStack.isEmpty()) {
                        inv.setItem(2, new ItemStack((ItemLike)NuclearScienceItems.ITEM_CELLANTIMATTERSMALL.get()));
                        cellStack.shrink(1);
                    }
                }
            }
            this.particles[1] = null;
            this.particles[0] = null;
        }
        return true;
    }

    public void addParticle(EntityParticle particle) {
        if (this.particles[0] == null && this.particles[1] == null) {
            this.particles[0] = particle;
        }
        if (this.particles[0] != null) {
            if (this.particles[0].getUUID().equals(particle.getUUID())) {
                return;
            }
            if (this.particles[1] == null) {
                this.particles[1] = particle;
            }
        }
        if (this.particles[1] != null) {
            if (this.particles[1].getUUID().equals(particle.getUUID())) {
                return;
            }
            if (this.particles[0] == null) {
                this.particles[0] = particle;
            }
        }
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("timesincespawn", this.timeSinceSpawn);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.timeSinceSpawn = compound.getInt("timesincespawn");
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (!this.level.isClientSide()) {
            this.hasRedstoneSignal.setValue((Object)this.level.hasNeighborSignal(this.getBlockPos()));
        }
    }
}

