/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.fission;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nuclearscience.api.turbine.ISteamReceiver;
import nuclearscience.common.block.BlockMeltedReactor;
import nuclearscience.common.inventory.container.ContainerFissionReactorCore;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.common.tile.reactor.fission.IFissionControlRod;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceRecipies;
import nuclearscience.registers.NuclearScienceSounds;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.categories.item2item.Item2ItemRecipe;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.registers.VoltaicDamageTypes;

public class TileFissionReactorCore
extends GenericTile {
    public static final int FUEL_ROD_COUNT = 4;
    public static final int DUETERIUM_SLOT = 4;
    public static final int OUTPUT_SLOT = 5;
    public static final int MELTDOWN_TEMPERATURE_ACTUAL = 5611;
    public static final int MELTDOWN_TEMPERATURE_CALC = 4407;
    public static final double WATER_TEMPERATURE = 10.0;
    public static final double AIR_TEMPERATURE = 15.0;
    public static final int STEAM_GEN_DIAMETER = 5;
    public static final int STEAM_GEN_HEIGHT = 2;
    private ISteamReceiver[][][] cachedReceivers = new ISteamReceiver[5][2][5];
    public SingleProperty<Double> temperature = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "temperature", (Object)15.0));
    public SingleProperty<Integer> fuelCount = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fuelCount", (Object)0));
    public SingleProperty<Boolean> hasDeuterium = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasDeuterium", (Object)false));
    private CachedTileOutput controlRodCache;
    private int ticksOverheating = 0;
    private List<RecipeHolder<VoltaicRecipe>> cachedRecipes;

    public TileFissionReactorCore(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_REACTORCORE.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickCommon(this::tickCommon).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(5).outputs(1)).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0, 1, 2, 3, 4}).setSlotsByDirection(BlockEntityUtils.MachineDirection.BOTTOM, new Integer[]{5}));
        this.addComponent((IComponent)new ComponentContainerProvider("reactorcore", (GenericTile)this).createMenu((id, player) -> new ContainerFissionReactorCore((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected void tickServer(ComponentTickable tickable) {
        boolean hasWater;
        double totstrength = (Double)this.temperature.getValue() * 10.0;
        int range = (int)(Math.sqrt(totstrength) / (5.0 * Math.sqrt(2.0)) * 2.0);
        if (range > 0 && totstrength > 0.0 && (Double)this.temperature.getValue() > 15.0) {
            RadiationSystem.addRadiationSource((Level)this.getLevel(), (SimpleRadiationSource)new SimpleRadiationSource(totstrength, 1.0, range, true, 30, this.getBlockPos(), true, false));
        }
        double decrease = ((Double)this.temperature.getValue() - 15.0) / 3000.0;
        if ((Integer)this.fuelCount.getValue() == 0) {
            decrease *= 25.0;
        }
        boolean bl = hasWater = !this.getBlockState().getFluidState().isEmpty();
        if (hasWater) {
            decrease += ((Double)this.temperature.getValue() - 10.0) / 5000.0;
        }
        if (decrease != 0.0) {
            this.temperature.setValue((Object)((Double)this.temperature.getValue() - (decrease < 0.001 && decrease > 0.0 ? 0.001 : (decrease > -0.001 && decrease < 0.0 ? -0.001 : decrease))));
        }
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        if ((Integer)this.fuelCount.getValue() > 0) {
            Iterator iterator;
            if (this.level.getRandom().nextFloat() < 0.01f) {
                SoundEvent sound = switch (this.level.random.nextIntBetweenInclusive(1, 6)) {
                    case 2 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_2.get();
                    case 3 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_3.get();
                    case 4 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_4.get();
                    case 5 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_5.get();
                    case 6 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_6.get();
                    default -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_1.get();
                };
                this.level.playSound(null, this.getBlockPos(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (this.level.getLevelData().getGameTime() % 10L == 0L && (Double)this.temperature.getValue() > 100.0) {
                AABB bb = AABB.ofSize((Vec3)new Vec3((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()), (double)4.0, (double)4.0, (double)4.0);
                List list = this.level.getEntitiesOfClass(LivingEntity.class, bb);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    LivingEntity living = (LivingEntity)iterator.next();
                    if (!this.level.getBlockState(living.getOnPos()).getFluidState().is(FluidTags.WATER)) continue;
                    living.hurt(living.damageSources().drown(), 3.0f);
                }
            }
            if (this.controlRodCache == null) {
                this.controlRodCache = new CachedTileOutput(this.getLevel(), this.worldPosition.below());
            }
            if (tickable.getTicks() % 10L == 0L && !this.controlRodCache.valid()) {
                this.controlRodCache.update(this.worldPosition.below());
            }
            int insertion = 0;
            if (this.controlRodCache.valid() && (iterator = this.controlRodCache.getSafe()) instanceof IFissionControlRod) {
                IFissionControlRod rod = (IFissionControlRod)((Object)iterator);
                insertion = rod.getInsertion();
            }
            double insertDecimal = 1.0 - (double)insertion / 100.0;
            if ((double)this.level.random.nextFloat() < insertDecimal) {
                for (int slot = 0; slot < 4; ++slot) {
                    ItemStack fuelRod = inv.getItem(slot);
                    fuelRod.setDamageValue((int)((long)(fuelRod.getDamageValue() + 1) + Math.round((Double)this.temperature.getValue()) / 4407L));
                    if (fuelRod.isEmpty() || fuelRod.getDamageValue() < fuelRod.getMaxDamage()) continue;
                    inv.setItem(slot, new ItemStack((ItemLike)NuclearScienceItems.ITEM_FUELSPENT.get()));
                }
            }
            this.temperature.setValue((Object)((Double)this.temperature.getValue() + (4407.0 * insertDecimal * (0.25 * ((double)((Integer)this.fuelCount.getValue()).intValue() / 2.0) + this.level.random.nextDouble() / 5.0) - (Double)this.temperature.getValue()) / (200.0 + 20.0 * (hasWater ? 4.0 : 1.0))));
            if ((Double)this.temperature.getValue() > (double)(5611 + this.level.random.nextInt(50)) && (Integer)this.fuelCount.getValue() > 0) {
                ++this.ticksOverheating;
                if (this.ticksOverheating > 200) {
                    this.meltdown();
                }
            }
        } else {
            this.ticksOverheating = 0;
        }
        this.temperature.setValue((Object)Math.max(15.0, (Double)this.temperature.getValue()));
        if (((Boolean)this.hasDeuterium.getValue()).booleanValue() && (Integer)this.fuelCount.getValue() > 0 && (double)this.level.random.nextFloat() < 1.0 / (5288400.0 / (Double)this.temperature.getValue())) {
            this.processFissReact(inv);
        }
    }

    protected void tickCommon(ComponentTickable tickable) {
        if (tickable.getTicks() % 20L == 0L) {
            this.level.getLightEngine().checkBlock(this.worldPosition);
        }
        this.produceSteam();
    }

    public void meltdown() {
        int radius = 2;
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockPos ppos = new BlockPos(this.worldPosition.getX() + i, this.worldPosition.getY() + j, this.worldPosition.getZ() + k);
                    BlockState state = this.level.getBlockState(ppos);
                    if (state.getBlock() != Blocks.WATER) continue;
                    this.level.setBlockAndUpdate(ppos, Blocks.AIR.defaultBlockState());
                }
            }
        }
        this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
        Explosion actual = new Explosion(this.level, null, this.level.damageSources().source(VoltaicDamageTypes.RADIATION), null, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), 20.0f, true, Explosion.BlockInteraction.KEEP, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE);
        radius = 3 * (Integer)this.fuelCount.getValue();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    double distance;
                    BlockPos ppos = new BlockPos(this.worldPosition.getX() + i, this.worldPosition.getY() + j, this.worldPosition.getZ() + k);
                    BlockState state = this.level.getBlockState(ppos);
                    if (!(state.getBlock().getExplosionResistance(state, (BlockGetter)this.level, ppos, actual) < (float)radius) || !((distance = Math.sqrt(i * i + j * j + k * k)) < (double)radius) || !((double)this.level.random.nextFloat() < 1.0 - 1.0E-4 * distance * distance * distance) || !((double)this.level.random.nextFloat() < 0.9)) continue;
                    this.level.getBlockState(ppos).onBlockExploded(this.level, ppos, actual);
                }
            }
        }
        this.level.explode(null, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), 20.0f, Level.ExplosionInteraction.BLOCK);
        this.level.setBlockAndUpdate(this.worldPosition, ((BlockMeltedReactor)((Object)NuclearScienceBlocks.BLOCK_MELTEDREACTOR.get())).defaultBlockState());
    }

    protected void produceSteam() {
        if ((Double)this.temperature.getValue() <= 400.0) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 5; ++k) {
                    boolean isFaceWater;
                    boolean isReactor2d;
                    boolean bl = isReactor2d = i - 2 == 0 && k - 2 == 0;
                    if (isReactor2d && j == 0) {
                        if (this.level.isClientSide || !((double)this.level.random.nextFloat() < (Double)this.temperature.getValue() / 4407000.0) || !this.level.getBlockState(this.worldPosition).hasProperty((Property)BlockStateProperties.WATERLOGGED)) continue;
                        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
                        continue;
                    }
                    int offsetX = this.worldPosition.getX() + i - 2;
                    int offsetY = this.worldPosition.getY() + j;
                    int offsetZ = this.worldPosition.getZ() + k - 2;
                    BlockPos offpos = new BlockPos(offsetX, offsetY, offsetZ);
                    if (!TileFissionReactorCore.isStillWater(this.getLevel(), offpos)) continue;
                    boolean bl2 = isFaceWater = TileFissionReactorCore.isStillWater(this.level, new BlockPos(offsetX, this.worldPosition.getY(), this.worldPosition.getZ())) || TileFissionReactorCore.isStillWater(this.level, new BlockPos(this.worldPosition.getX(), this.worldPosition.getY(), offsetZ)) || isReactor2d;
                    if (!isFaceWater) continue;
                    if (!this.level.isClientSide) {
                        ISteamReceiver turbine = this.cachedReceivers[i][j][k];
                        if (turbine != null) {
                            if (turbine.isStillValid()) {
                                this.cachedReceivers[i][j][k] = null;
                            }
                            double temp = (Double)this.temperature.getValue();
                            turbine.receiveSteam((int)temp, (int)((Double)NuclearConfig.INSTANCE.FISSIONREACTOR_MAXENERGYTARGET.get() / (500.0 * (5611.0 / (Double)this.temperature.getValue()))));
                        }
                        if ((double)this.level.random.nextFloat() < (Double)this.temperature.getValue() / 4407000.0 && this.level.getBlockState(offpos).is(Blocks.WATER)) {
                            this.level.setBlockAndUpdate(offpos, Blocks.AIR.defaultBlockState());
                            continue;
                        }
                        if (turbine != null && !turbine.isStillValid()) continue;
                        BlockEntity above = this.level.getBlockEntity(new BlockPos(offsetX, offsetY + 1, offsetZ));
                        if (above instanceof ISteamReceiver) {
                            ISteamReceiver trb;
                            this.cachedReceivers[i][j][k] = trb = (ISteamReceiver)above;
                            continue;
                        }
                        this.cachedReceivers[i][j][k] = null;
                        continue;
                    }
                    if (!this.level.isClientSide || !((double)this.level.random.nextFloat() < (Double)this.temperature.getValue() / 16833.0)) continue;
                    double offsetFX = (double)offsetX + this.level.random.nextDouble() / 2.0 * (double)(this.level.random.nextBoolean() ? -1 : 1);
                    double offsetFY = (double)offsetY + this.level.random.nextDouble() / 2.0 * (double)(this.level.random.nextBoolean() ? -1 : 1);
                    double offsetFZ = (double)offsetZ + this.level.random.nextDouble() / 2.0 * (double)(this.level.random.nextBoolean() ? -1 : 1);
                    this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, offsetFX + 0.5, offsetFY + (double)0.2f, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                    if (this.level.random.nextInt(3) != 0) continue;
                    this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, offsetFX + 0.5, offsetFY + 0.5, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void processFissReact(ComponentInventory inv) {
        ItemStack input = inv.getItem(4);
        ItemStack output = inv.getItem(5);
        if (input.isEmpty()) {
            return;
        }
        if (this.cachedRecipes == null || this.cachedRecipes.isEmpty()) {
            this.cachedRecipes = VoltaicRecipe.findRecipesbyType((RecipeType)((RecipeType)NuclearScienceRecipies.FISSION_REACTOR_TYPE.get()), (Level)this.level);
        }
        for (RecipeHolder<VoltaicRecipe> iRecipe : this.cachedRecipes) {
            Item2ItemRecipe recipe = (Item2ItemRecipe)iRecipe.value();
            for (CountableIngredient ing : recipe.getCountedIngredients()) {
                if (!ing.test(input)) continue;
                if (output.isEmpty()) {
                    inv.setItem(5, recipe.getItemRecipeOutput().copy());
                    input.shrink(((CountableIngredient)recipe.getCountedIngredients().get(0)).getStackSize());
                    continue;
                }
                if (output.getCount() > output.getMaxStackSize() + recipe.getItemRecipeOutput().getCount()) continue;
                output.grow(recipe.getItemRecipeOutput().getCount());
                input.shrink(((CountableIngredient)recipe.getCountedIngredients().get(0)).getStackSize());
            }
        }
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        if (this.level.isClientSide()) {
            return;
        }
        if (slot == -1 || slot < 4) {
            this.fuelCount.setValue((Object)0);
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = inv.getItem(i);
                int fuelValue = 0;
                if (stack.getItem() == NuclearScienceItems.ITEM_FUELLEUO2.get()) {
                    fuelValue = 2;
                } else if (stack.getItem() == NuclearScienceItems.ITEM_FUELHEUO2.get()) {
                    fuelValue = 3;
                } else if (stack.getItem() == NuclearScienceItems.ITEM_FUELPLUTONIUM.get()) {
                    fuelValue = 2;
                }
                this.fuelCount.setValue((Object)((Integer)this.fuelCount.getValue() + fuelValue));
            }
        }
        if (slot == -1 || slot == 4) {
            this.hasDeuterium.setValue((Object)(!inv.getItem(4).isEmpty() ? 1 : 0));
        }
    }

    public static boolean isStillWater(Level world, BlockPos pos) {
        FluidState fluidState = world.getFluidState(pos);
        return fluidState.is(FluidTags.WATER) && fluidState.isSource();
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("ticksoverheating", this.ticksOverheating);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.ticksOverheating = compound.getInt("ticksoverheating");
    }

    public static double getActualTemp(double temperature) {
        return temperature / 4.0 + 15.0;
    }
}

