/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.fusion;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.api.turbine.ISteamReceiver;
import nuclearscience.common.block.BlockPlasma;
import nuclearscience.common.block.subtype.SubtypeNuclearMachine;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.object.CachedTileOutput;

public class TilePlasma
extends GenericTile {
    public final SingleProperty<Integer> ticksExisted = (SingleProperty)this.property((AbstractProperty)((SingleProperty)new SingleProperty(PropertyTypes.INTEGER, "existed", (Object)0).setNoUpdateClient()));
    public final SingleProperty<Integer> spread = (SingleProperty)this.property((AbstractProperty)((SingleProperty)new SingleProperty(PropertyTypes.INTEGER, "spread", (Object)6).setNoUpdateClient()));
    private CachedTileOutput output;

    public TilePlasma(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_PLASMA.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
    }

    public void tickServer(ComponentTickable tickable) {
        this.ticksExisted.setValue((Object)((Integer)this.ticksExisted.getValue() + 1));
        if ((Integer)this.ticksExisted.getValue() > 80) {
            this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
            return;
        }
        if ((Integer)this.ticksExisted.getValue() == 1 && (Integer)this.spread.getValue() > 0) {
            for (Direction dir : Direction.values()) {
                BlockEntity tile;
                BlockPos offset = this.worldPosition.relative(dir);
                BlockState state = this.level.getBlockState(offset);
                boolean didntExist = false;
                if (state.getBlock() != this.getBlockState().getBlock()) {
                    didntExist = true;
                    if (state.getDestroySpeed((BlockGetter)this.level, offset) != -1.0f && !state.is(NuclearScienceTags.Blocks.FUSION_CONTAINMENT) && state.getBlock() != NuclearScienceBlocks.BLOCKS_NUCLEARMACHINE.getValue((Object)SubtypeNuclearMachine.fusionreactorcore)) {
                        this.level.setBlockAndUpdate(offset, ((BlockPlasma)((Object)NuclearScienceBlocks.BLOCK_PLASMA.get())).defaultBlockState());
                    }
                }
                if (!((tile = this.level.getBlockEntity(offset)) instanceof TilePlasma)) continue;
                TilePlasma plasma = (TilePlasma)tile;
                if ((Integer)plasma.ticksExisted.getValue() > 1 && (Integer)plasma.spread.getValue() < (Integer)this.spread.getValue()) {
                    plasma.ticksExisted.setValue((Object)((Integer)this.ticksExisted.getValue() - 1));
                }
                if (!didntExist) continue;
                plasma.spread.setValue((Object)((Integer)this.spread.getValue() - 1));
            }
        }
        if ((Integer)this.ticksExisted.getValue() > 1 && this.level.getBlockState(this.getBlockPos().relative(Direction.UP)).is(NuclearScienceTags.Blocks.FUSION_CONTAINMENT) && this.level.getFluidState(this.getBlockPos().relative(Direction.UP, 2)).is(FluidTags.WATER)) {
            if (this.output == null) {
                this.output = new CachedTileOutput(this.level, this.getBlockPos().relative(Direction.UP, 3));
            } else if (this.output.getSafe() instanceof ISteamReceiver) {
                ISteamReceiver turbine = (ISteamReceiver)this.output.getSafe();
                turbine.receiveSteam(Integer.MAX_VALUE, (int)((Double)NuclearConfig.INSTANCE.FUSIONREACTOR_MAXENERGYTARGET.get() / 2260.0));
            }
        }
    }
}

