/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import nuclearscience.common.inventory.container.ContainerControlRodModule;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.util.GenericTileInterfaceBound;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.registers.VoltaicItems;

public class TileControlRodModule
extends GenericTileInterfaceBound {
    private Direction relativeBack;
    public final SingleProperty<Integer> insertion = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "insertion", (Object)0));
    public final SingleProperty<Integer> redstoneSignal = ((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "redstonesignal", (Object)0))).onChange((prop, oldVal) -> {
        if (this.level == null || this.level.isClientSide || prop.getValue() == oldVal) {
            return;
        }
        double perc = (double)((Integer)prop.getValue()).intValue() / 15.0;
        double tot = perc * 100.0;
        int mult = (int)(tot / 10.0);
        this.insertion.setValue((Object)(mult * 10));
    });

    public TileControlRodModule(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)NuclearScienceTiles.TILE_CONTROLRODMODULE.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentContainerProvider("controlrodmodule", (GenericTile)this).createMenu((id, player) -> new ContainerControlRodModule((int)id, (Inventory)player, (Container)new SimpleContainer(0), (ContainerData)this.getCoordsArray())));
        this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
    }

    @Override
    public boolean checkLinkedPosition(GenericTileInterface inter) {
        return ((BlockPos)inter.controlRodLocation.getValue()).equals((Object)this.getBlockPos());
    }

    @Override
    public Direction getCableLocation() {
        return this.relativeBack;
    }

    public void onBlockStateUpdate(BlockState oldState, BlockState newState) {
        super.onBlockStateUpdate(oldState, newState);
        if (!this.level.isClientSide() && oldState.hasProperty((Property)VoltaicBlockStates.FACING) && newState.hasProperty((Property)VoltaicBlockStates.FACING) && oldState.getValue((Property)VoltaicBlockStates.FACING) != newState.getValue((Property)VoltaicBlockStates.FACING)) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("relativeback", this.relativeBack.ordinal());
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.relativeBack = Direction.values()[compound.getInt("relativeback")];
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        super.onNeightborChanged(neighbor, blockStateTrigger);
        if (!this.level.isClientSide) {
            this.redstoneSignal.setValue((Object)this.getLevel().getBestNeighborSignal(this.getBlockPos()));
        }
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (!this.level.isClientSide()) {
            if (!this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
                return;
            }
            TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
            if (cable.isRemoved()) {
                return;
            }
            ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
            GenericTileInterface inter = network.getInterface((BlockPos)this.interfaceLocation.getValue());
            if (inter == null) {
                return;
            }
            inter.controlRodLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
        }
    }

    @Override
    public GenericTileInterface.InterfaceType[] getValidInterfaces() {
        return CONTROL_RODS;
    }

    public ItemInteractionResult useWithItem(ItemStack used, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.getItemInHand(hand).is((Holder)VoltaicItems.ITEM_WRENCH)) {
            if (this.hasComponent(IComponentType.ContainerProvider)) {
                if (!this.level.isClientSide) {
                    player.openMenu((MenuProvider)this.getComponent(IComponentType.ContainerProvider));
                    player.awardStat(Stats.INTERACT_WITH_FURNACE);
                }
                return ItemInteractionResult.CONSUME;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useWithItem(used, player, hand, hit);
    }

    public int getComparatorSignal() {
        return (int)((double)((Integer)this.insertion.getValue()).intValue() / 100.0 * 15.0);
    }

    public InteractionResult useWithoutItem(Player player, BlockHitResult hit) {
        if (this.level.isClientSide()) {
            return InteractionResult.CONSUME;
        }
        if (player.isShiftKeyDown()) {
            this.insertion.setValue((Object)((Integer)this.insertion.getValue() - 10));
            if ((Integer)this.insertion.getValue() < 0) {
                this.insertion.setValue((Object)100);
            }
        } else {
            this.insertion.setValue((Object)((Integer)this.insertion.getValue() + 10));
            if ((Integer)this.insertion.getValue() > 100) {
                this.insertion.setValue((Object)0);
            }
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void onInterfacePropChange(SingleProperty<BlockPos> prop, BlockPos old) {
        GenericTileInterface inter;
        super.onInterfacePropChange(prop, old);
        boolean oldInval = old.equals((Object)BlockEntityUtils.OUT_OF_REACH);
        boolean newInval = ((BlockPos)prop.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH);
        if (oldInval && newInval) {
            return;
        }
        if (this.networkCable == null || !this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            return;
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.isRemoved()) {
            return;
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        if (oldInval && !newInval) {
            GenericTileInterface inter2 = network.getInterface((BlockPos)prop.getValue());
            if (inter2 != null) {
                inter2.controlRodLocation.setValue((Object)this.getBlockPos());
            }
        } else if (!oldInval && newInval && (inter = network.getInterface(old)) != null) {
            inter.controlRodLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
        }
    }
}

