/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.tile.reactor.logisticsnetwork.util.GenericTileLogisticsMember;
import nuclearscience.registers.NuclearScienceSounds;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileController
extends GenericTileLogisticsMember
implements ITickableSound {
    public static final double USAGE = 100.0;
    public final SingleProperty<Boolean> active = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "active", (Object)false));
    private Direction relativeBack;
    private boolean isSoundPlaying = false;

    public TileController(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)NuclearScienceTiles.TILE_LOGISTICSCONTROLLER.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).voltage(120.0).maxJoules(2000.0));
        this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        boolean canRun;
        super.tickServer(tickable);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        boolean bl = canRun = electro.getJoulesStored() >= 100.0;
        if (BlockEntityUtils.isLit((GenericTile)this) ^ canRun) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)canRun);
        }
        if (canRun) {
            electro.setJoulesStored(electro.getJoulesStored() - 100.0);
            this.active.setValue((Object)canRun);
        }
    }

    public void tickClient(ComponentTickable tickable) {
        if (!this.isSoundPlaying && this.shouldPlaySound()) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)NuclearScienceSounds.SOUND_LOGISTICSCONTROLLER.get()), (BlockEntity)this, (boolean)true);
        }
    }

    @Override
    public Direction getCableLocation() {
        return this.relativeBack;
    }

    @Override
    public boolean canConnect(ReactorLogisticsNetwork network) {
        return network.getController() == null || network.getController().getBlockPos().equals((Object)this.getBlockPos());
    }

    public void onBlockStateUpdate(BlockState oldState, BlockState newState) {
        super.onBlockStateUpdate(oldState, newState);
        if (!this.level.isClientSide() && oldState.hasProperty((Property)VoltaicBlockStates.FACING) && newState.hasProperty((Property)VoltaicBlockStates.FACING) && oldState.getValue((Property)VoltaicBlockStates.FACING) != newState.getValue((Property)VoltaicBlockStates.FACING)) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("relativeback", this.relativeBack.ordinal());
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.relativeBack = Direction.values()[compound.getInt("relativeback")];
    }

    public boolean isActive() {
        return (Boolean)this.active.getValue();
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Boolean)this.active.getValue();
    }
}

