/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import nuclearscience.common.inventory.container.ContainerThermometerModule;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.util.GenericTileInterfaceBound;
import nuclearscience.common.tile.reactor.moltensalt.TileMSReactorCore;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileThermometerModule
extends GenericTileInterfaceBound {
    private Direction relativeBack;
    public final SingleProperty<Integer> mode = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "comparitormode", (Object)Mode.CONSTANT.ordinal()));
    public final SingleProperty<Boolean> inverted = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "inverted", (Object)false));
    public final SingleProperty<Double> targetTemperature = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "targettemperature", (Object)0.0));
    public final SingleProperty<Double> trackedTemperature = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "trackedtemperature", (Object)0.0));
    public final SingleProperty<Integer> redstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "redstonesignal", (Object)0));
    public static final int MAX_REDSTONE = 15;

    public TileThermometerModule(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)NuclearScienceTiles.TILE_THERMOMETERMODULE.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentContainerProvider("thermometermodule", (GenericTile)this).createMenu((id, player) -> new ContainerThermometerModule((int)id, (Inventory)player, (Container)new SimpleContainer(0), (ContainerData)this.getCoordsArray())));
        this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        super.tickServer(tickable);
        GenericTileInterface.InterfaceType type = GenericTileInterface.InterfaceType.values()[(Integer)this.interfaceType.getValue()];
        if (type == GenericTileInterface.InterfaceType.NONE || ((BlockPos)this.interfaceLocation.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH)) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        if (!this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.isRemoved()) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        if (!network.isControllerActive()) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        GenericTileInterface genericInterface = network.getInterface((BlockPos)this.interfaceLocation.getValue());
        if (genericInterface == null || genericInterface.getInterfaceType() != type) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        if (genericInterface.reactor == null || !genericInterface.reactor.valid()) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        double temp = -1.0;
        Object object = genericInterface.reactor.getSafe();
        if (object instanceof TileFissionReactorCore) {
            TileFissionReactorCore core = (TileFissionReactorCore)((Object)object);
            temp = TileFissionReactorCore.getActualTemp((Double)core.temperature.getValue());
        } else {
            object = genericInterface.reactor.getSafe();
            if (object instanceof TileMSReactorCore) {
                TileMSReactorCore core = (TileMSReactorCore)((Object)object);
                temp = (Double)core.temperature.getValue();
            }
        }
        if (temp < 0.0) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        double perc = 0.0;
        this.trackedTemperature.setValue((Object)temp);
        switch (Mode.values()[(Integer)this.mode.getValue()].ordinal()) {
            case 1: {
                if (((Boolean)this.inverted.getValue()).booleanValue()) {
                    if (temp <= (Double)this.targetTemperature.getValue()) {
                        perc = 1.0;
                        break;
                    }
                    perc = 0.0;
                    break;
                }
                if (temp >= (Double)this.targetTemperature.getValue()) {
                    perc = 1.0;
                    break;
                }
                perc = 0.0;
                break;
            }
            case 0: {
                if (((Boolean)this.inverted.getValue()).booleanValue()) {
                    if (temp == 0.0 || (Double)this.targetTemperature.getValue() == 0.0) {
                        perc = 1.0;
                        break;
                    }
                    perc = 1.0 - Math.min(1.0, temp / (Double)this.targetTemperature.getValue());
                    break;
                }
                perc = temp == 0.0 || (Double)this.targetTemperature.getValue() == 0.0 ? 0.0 : Math.min(1.0, temp / (Double)this.targetTemperature.getValue());
            }
        }
        this.redstoneSignal.setValue((Object)((int)(15.0 * perc)));
    }

    @Override
    public boolean checkLinkedPosition(GenericTileInterface inter) {
        return true;
    }

    @Override
    public Direction getCableLocation() {
        return this.relativeBack;
    }

    public void onBlockStateUpdate(BlockState oldState, BlockState newState) {
        super.onBlockStateUpdate(oldState, newState);
        if (!this.level.isClientSide() && oldState.hasProperty((Property)VoltaicBlockStates.FACING) && newState.hasProperty((Property)VoltaicBlockStates.FACING) && oldState.getValue((Property)VoltaicBlockStates.FACING) != newState.getValue((Property)VoltaicBlockStates.FACING)) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("relativeback", this.relativeBack.ordinal());
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.relativeBack = Direction.values()[compound.getInt("relativeback")];
    }

    @Override
    public GenericTileInterface.InterfaceType[] getValidInterfaces() {
        return TEMPERATURE;
    }

    public int getComparatorSignal() {
        return (Integer)this.redstoneSignal.getValue();
    }

    public static enum Mode {
        BUILD_UP,
        CONSTANT;

    }
}

