/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork.interfaces;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.common.tile.reactor.fission.IFissionControlRod;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileControlRodModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileSupplyModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class TileFissionInterface
extends GenericTileInterface
implements IFissionControlRod {
    public final SingleProperty<Integer> insertion = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "insertion", (Object)0));

    public TileFissionInterface(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)NuclearScienceTiles.TILE_FISSIONINTERFACE.get(), worldPos, blockState);
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        int j;
        ItemStack item;
        super.tickServer(tickable);
        if (!this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            this.insertion.setValue((Object)0);
            return;
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.isRemoved()) {
            this.insertion.setValue((Object)0);
            return;
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        if (!network.isControllerActive()) {
            this.insertion.setValue((Object)0);
            return;
        }
        TileControlRodModule controlRod = network.getControlRod((BlockPos)this.controlRodLocation.getValue());
        if (controlRod == null) {
            this.insertion.setValue((Object)0);
        } else {
            this.insertion.setValue(controlRod.insertion.getValue());
        }
        TileSupplyModule supplyModule = network.getSupplyModule((BlockPos)this.supplyModuleLocation.getValue());
        if (!this.reactor.valid() || supplyModule == null || !(this.reactor.getSafe() instanceof TileFissionReactorCore)) {
            return;
        }
        TileFissionReactorCore core = (TileFissionReactorCore)((Object)this.reactor.getSafe());
        ComponentInventory coreInv = (ComponentInventory)core.getComponent(IComponentType.Inventory);
        ComponentInventory supplyInv = (ComponentInventory)supplyModule.getComponent(IComponentType.Inventory);
        boolean isExtractingSpentCell = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_1) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_2) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_3) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_4);
        boolean isInsertingFuelCell = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_1) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_2) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_3) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_4);
        boolean isExtractingTritium = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_TRITIUM_EXTRACT);
        boolean isInsertingDeuterium = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_DEUTERIUM_INSERT);
        ItemStack deuterium = coreInv.getItem(4);
        if (!isInsertingFuelCell) {
            for (int i = 0; i < 4; ++i) {
                item = coreInv.getItem(i);
                if (item.isEmpty() || !item.is(NuclearScienceTags.Items.FUELROD_SPENT)) continue;
                boolean inserted = false;
                for (j = 9; j < 18; ++j) {
                    if (!supplyInv.getItem(j).isEmpty()) continue;
                    supplyInv.setItem(j, item.copy());
                    coreInv.setItem(i, ItemStack.EMPTY);
                    inserted = true;
                    break;
                }
                if (!inserted) continue;
                switch (i) {
                    case 0: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_1.ordinal());
                        break;
                    }
                    case 1: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_2.ordinal());
                        break;
                    }
                    case 2: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_3.ordinal());
                        break;
                    }
                    case 3: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_4.ordinal());
                    }
                }
                isExtractingSpentCell = true;
            }
        }
        if (!isInsertingDeuterium && !coreInv.areOutputsEmpty()) {
            item = coreInv.getItem(5);
            boolean extracted = false;
            for (j = 9; j < 18 && !coreInv.areOutputsEmpty() && !item.isEmpty(); ++j) {
                ItemStack destItem = supplyInv.getItem(j);
                if (destItem.isEmpty()) {
                    supplyInv.setItem(j, item.copy());
                    coreInv.setItem(5, ItemStack.EMPTY);
                    extracted = true;
                    continue;
                }
                if (!destItem.is(NuclearScienceTags.Items.CELL_TRITIUM) || destItem.getCount() >= destItem.getMaxStackSize()) continue;
                int taken = Math.min(destItem.getMaxStackSize() - destItem.getCount(), item.getCount());
                destItem.grow(taken);
                item.shrink(taken);
                extracted = true;
            }
            if (extracted) {
                this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_TRITIUM_EXTRACT.ordinal());
                isExtractingTritium = true;
            }
        }
        if (!isExtractingSpentCell && !supplyInv.areInputsEmpty()) {
            block15: for (int i = 0; i < 4; ++i) {
                item = coreInv.getItem(i);
                if (item.is(NuclearScienceTags.Items.FUELROD_URANIUM_LOW_EN) || item.is(NuclearScienceTags.Items.FUELROD_URANIUM_HIGH_EN) || item.is(NuclearScienceTags.Items.FUELROD_PLUTONIUM) || !item.isEmpty()) continue;
                boolean inserted = false;
                for (int j2 = 0; j2 < 9; ++j2) {
                    ItemStack supplyItem = supplyInv.getItem(j2);
                    if (!supplyItem.is(NuclearScienceTags.Items.FUELROD_URANIUM_LOW_EN) && !supplyItem.is(NuclearScienceTags.Items.FUELROD_URANIUM_HIGH_EN) && !supplyItem.is(NuclearScienceTags.Items.FUELROD_PLUTONIUM)) continue;
                    coreInv.setItem(i, supplyItem.copy());
                    supplyInv.setItem(j2, ItemStack.EMPTY);
                    inserted = true;
                    break;
                }
                if (!inserted) continue;
                switch (i) {
                    case 0: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_1.ordinal());
                        continue block15;
                    }
                    case 1: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_2.ordinal());
                        continue block15;
                    }
                    case 2: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_3.ordinal());
                        continue block15;
                    }
                    case 3: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_4.ordinal());
                    }
                }
            }
        }
        if (!isExtractingTritium && (deuterium.isEmpty() || deuterium.is(NuclearScienceTags.Items.CELL_DEUTERIUM) && deuterium.getCount() < deuterium.getMaxStackSize())) {
            boolean taken = false;
            for (int j3 = 0; !(j3 >= 9 || (deuterium = coreInv.getItem(4)).is(NuclearScienceTags.Items.CELL_DEUTERIUM) && deuterium.getCount() >= deuterium.getMaxStackSize()); ++j3) {
                item = supplyInv.getItem(j3).copy();
                if (!item.is(NuclearScienceTags.Items.CELL_DEUTERIUM)) continue;
                if (deuterium.isEmpty()) {
                    coreInv.setItem(4, item.copy());
                    supplyInv.setItem(j3, ItemStack.EMPTY);
                    taken = true;
                    continue;
                }
                if (deuterium.getCount() >= deuterium.getMaxStackSize()) continue;
                int amt = Math.min(item.getCount(), deuterium.getMaxStackSize() - deuterium.getCount());
                supplyInv.removeItem(j3, amt);
                deuterium.grow(amt);
                taken = true;
            }
            if (taken) {
                this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_DEUTERIUM_INSERT.ordinal());
            }
        }
        this.handleServerAnimations(tickable);
    }

    @Override
    public int getInsertion() {
        return (Integer)this.insertion.getValue();
    }

    @Override
    public Direction getReactorDirection() {
        return Direction.UP;
    }

    @Override
    public GenericTileInterface.InterfaceType getInterfaceType() {
        return GenericTileInterface.InterfaceType.FISSION;
    }

    @Override
    public Direction getCableLocation() {
        return Direction.DOWN;
    }
}

