/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.moltensalt;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.inventory.container.ContainerMSReactorCore;
import nuclearscience.common.network.MoltenSaltNetwork;
import nuclearscience.common.tile.reactor.moltensalt.IMSControlRod;
import nuclearscience.common.tile.reactor.moltensalt.TileFreezePlug;
import nuclearscience.common.tile.reactor.moltensalt.TileMoltenSaltPipe;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.object.CachedTileOutput;

public class TileMSReactorCore
extends GenericTile {
    public static final int MELTDOWN_TEMPERATURE = 1000;
    public static final double FUEL_CAPACITY = 1000.0;
    public static final double FUEL_USAGE_RATE = 0.01;
    public static final double WASTE_CAP = 1000.0;
    public static final double WASTE_PER_MB = 0.01;
    public SingleProperty<Double> temperature = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "temperature", (Object)15.0));
    public SingleProperty<Double> currentFuel = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "currentfuel", (Object)0.0));
    public SingleProperty<Double> currentWaste = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "currentwaste", (Object)0.0));
    public SingleProperty<Boolean> wasteIsFull = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "wasteisfull", (Object)false));
    private CachedTileOutput outputCache;
    private CachedTileOutput plugCache;
    private CachedTileOutput controlRodCache;
    public CachedTileOutput clientPlugCache;

    public TileMSReactorCore(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_MSRREACTORCORE.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentContainerProvider("msrreactorcore", (GenericTile)this).createMenu((id, player) -> new ContainerMSReactorCore((int)id, (Inventory)player, null, (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tick) {
        Object object;
        IMSControlRod rod;
        Object object2;
        TileFreezePlug freeze;
        Object object3;
        double change;
        double totstrength = (Double)this.temperature.getValue() * Math.pow(3.0, Math.pow((Double)this.temperature.getValue() / 1000.0, 9.0));
        int range = (int)(Math.sqrt(totstrength) / (5.0 * Math.sqrt(2.0)) * 2.0);
        if (range > 0 && totstrength > 0.0 && (Double)this.temperature.getValue() > 15.0) {
            RadiationSystem.addRadiationSource((Level)this.getLevel(), (SimpleRadiationSource)new SimpleRadiationSource(totstrength, 1.0, range, true, 30, this.getBlockPos(), true, false));
        }
        if ((change = ((Double)this.temperature.getValue() - 15.0) / 3000.0 + ((Double)this.temperature.getValue() - 15.0) / 5000.0) != 0.0) {
            this.temperature.setValue((Object)((Double)this.temperature.getValue() - (change < 0.001 && change > 0.0 ? 0.001 : (change > -0.001 && change < 0.0 ? -0.001 : change))));
        }
        if (this.outputCache == null) {
            this.outputCache = new CachedTileOutput(this.level, new BlockPos((Vec3i)this.worldPosition).relative(Direction.UP));
        }
        if (this.plugCache == null) {
            this.plugCache = new CachedTileOutput(this.level, new BlockPos((Vec3i)this.worldPosition).relative(Direction.DOWN));
        }
        if (this.controlRodCache == null) {
            this.controlRodCache = new CachedTileOutput(this.getLevel(), this.getBlockPos().relative(this.getFacing()));
        }
        if (tick.getTicks() % 40L == 0L) {
            if (!this.outputCache.valid()) {
                this.outputCache.update(new BlockPos((Vec3i)this.worldPosition).relative(Direction.UP));
            }
            if (!this.plugCache.valid()) {
                this.plugCache.update(new BlockPos((Vec3i)this.worldPosition).relative(Direction.DOWN));
            }
        }
        if (!this.controlRodCache.valid() && tick.getTicks() % 10L == 0L) {
            this.controlRodCache.update(this.getBlockPos().relative(this.getFacing().getOpposite()));
        }
        if (!(this.plugCache.valid() && (object3 = this.plugCache.getSafe()) instanceof TileFreezePlug && (freeze = (TileFreezePlug)((Object)object3)).isFrozen())) {
            return;
        }
        if ((Double)this.currentFuel.getValue() < 0.01) {
            return;
        }
        int insertion = 0;
        if (this.controlRodCache.valid() && (object2 = this.controlRodCache.getSafe()) instanceof IMSControlRod && (rod = (IMSControlRod)object2).facingDir() == this.getFacing()) {
            insertion = rod.getInsertion();
        }
        double insertDecimal = 1.0 - (double)insertion / 100.0;
        double fuelUse = Math.min((Double)this.currentFuel.getValue(), 0.01 * insertDecimal * Math.pow(2.0, Math.pow((Double)this.temperature.getValue() / 900.0, 4.0)));
        double wasteProduced = Math.min((Double)this.currentFuel.getValue(), 0.01 * insertDecimal * Math.pow(2.0, Math.pow((Double)this.temperature.getValue() / 900.0, 4.0)));
        if ((Double)this.currentWaste.getValue() > 1000.0 - wasteProduced) {
            this.wasteIsFull.setValue((Object)true);
            return;
        }
        this.wasteIsFull.setValue((Object)false);
        this.currentWaste.setValue((Object)((Double)this.currentWaste.getValue() + wasteProduced));
        this.currentFuel.setValue((Object)((Double)this.currentFuel.getValue() - fuelUse));
        this.temperature.setValue((Object)((Double)this.temperature.getValue() + (1000.0 * insertDecimal * (1.2 + this.level.random.nextDouble() / 5.0) - (Double)this.temperature.getValue()) / 600.0));
        if (this.outputCache.valid() && (object = this.outputCache.getSafe()) instanceof TileMoltenSaltPipe) {
            TileMoltenSaltPipe pipe = (TileMoltenSaltPipe)((Object)object);
            MoltenSaltNetwork net = (MoltenSaltNetwork)pipe.getNetwork();
            net.emit((Double)this.temperature.getValue() * ((TileFreezePlug)((Object)this.plugCache.getSafe())).getSaltBonus(), new ArrayList<BlockEntity>(), false);
        }
    }

    public void tickClient(ComponentTickable tickable) {
        if (this.clientPlugCache == null) {
            this.clientPlugCache = new CachedTileOutput(this.level, new BlockPos((Vec3i)this.worldPosition).relative(Direction.DOWN));
        }
        if (tickable.getTicks() % 40L == 0L && !this.clientPlugCache.valid()) {
            this.clientPlugCache.update(new BlockPos((Vec3i)this.worldPosition).relative(Direction.DOWN));
        }
    }
}

