/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.moltensalt;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.inventory.container.ContainerMoltenSaltSupplier;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.common.tile.reactor.moltensalt.TileMSReactorCore;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileMoltenSaltSupplier
extends GenericTile {
    public static final double AMT_PER_SALT = 250.0;
    public static final double AMT_PER_WASTE = 300.0;
    protected CachedTileOutput output;
    public final SingleProperty<Double> reactorWaste = (SingleProperty)this.property((AbstractProperty)((SingleProperty)new SingleProperty(PropertyTypes.DOUBLE, "reactorwaste", (Object)0.0).setNoSave()));

    public TileMoltenSaltSupplier(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_MOLTENSALTSUPPLIER.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(((Double)NuclearConfig.INSTANCE.MOLTENSALTSUPPLIER_VOLTAGE.get()).doubleValue()).extractPower((x, y) -> TransferPack.EMPTY).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).maxJoules((Double)NuclearConfig.INSTANCE.MOLTENSALTSUPPLIER_USAGE_PER_TICK.get() * 20.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1).outputs(1)).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT, BlockEntityUtils.MachineDirection.TOP}).setDirectionsBySlot(Integer.valueOf(1), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).valid((slot, stack, i) -> stack.getItem() == NuclearScienceItems.ITEM_LIFHT4PUF3.get()));
        this.addComponent((IComponent)new ComponentContainerProvider("moltensaltsupplier", (GenericTile)this).createMenu((id, player) -> new ContainerMoltenSaltSupplier((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tickable) {
        boolean enoughPower;
        Direction dir = this.getFacing();
        if (this.output == null) {
            this.output = new CachedTileOutput(this.level, this.worldPosition.relative(dir.getOpposite()));
        }
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)inv, (int)((Integer)NuclearConfig.INSTANCE.MOLTEN_SAL_SUPPLIER_RADIATION_RADIUS.get()), (boolean)true, (int)30, (boolean)true, (boolean)false);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        boolean bl = enoughPower = electro.getJoulesStored() >= (Double)NuclearConfig.INSTANCE.MOLTENSALTSUPPLIER_USAGE_PER_TICK.get();
        if (!enoughPower) {
            return;
        }
        if (BlockEntityUtils.isLit((GenericTile)this) ^ enoughPower) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)enoughPower);
        }
        electro.joules(electro.getJoulesStored() - (Double)NuclearConfig.INSTANCE.MOLTENSALTSUPPLIER_USAGE_PER_TICK.get());
        if (tickable.getTicks() % 40L == 0L) {
            this.output.update(this.worldPosition.relative(dir.getOpposite()));
        }
        ItemStack fuel = inv.getItem(0);
        if (!this.output.valid() || !(this.output.getSafe() instanceof TileMSReactorCore)) {
            this.reactorWaste.setValue((Object)0.0);
            return;
        }
        TileMSReactorCore core = (TileMSReactorCore)((Object)this.output.getSafe());
        this.reactorWaste.setValue(core.currentWaste.getValue());
        if (fuel.isEmpty()) {
            return;
        }
        if (core.getFacing() != dir) {
            return;
        }
        if (1000.0 - (Double)core.currentFuel.getValue() >= 250.0) {
            fuel.shrink(1);
            core.currentFuel.setValue((Object)((Double)core.currentFuel.getValue() + 250.0));
        }
        if ((Double)core.currentWaste.getValue() < 300.0) {
            return;
        }
        ItemStack waste = inv.getItem(1);
        if (waste.getCount() >= waste.getMaxStackSize()) {
            return;
        }
        if (waste.isEmpty()) {
            inv.setItem(1, new ItemStack((ItemLike)NuclearScienceItems.ITEM_FISSILE_SALT.get()));
        } else {
            waste.grow(1);
            inv.setItem(1, waste);
        }
        core.currentWaste.setValue((Object)((Double)core.currentWaste.getValue() - 300.0));
    }
}

