/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.datagen.server.recipe.custom.fluiditem2item;

import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import nuclearscience.common.block.subtype.SubtypeIrradiatedBlock;
import nuclearscience.common.recipe.categories.fluiditem2item.RadioactiveProcessorRecipe;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceItems;
import voltaic.common.tags.VoltaicTags;
import voltaic.datagen.utils.server.recipe.AbstractRecipeGenerator;
import voltaic.datagen.utils.server.recipe.builders.BaseRecipeBuilder;
import voltaic.datagen.utils.server.recipe.builders.FluidItem2ItemBuilder;

public class NuclearScienceRadioactiveProcessorRecipes
extends AbstractRecipeGenerator {
    public static double RADIOACTIVEPROCESSOR_USAGE_PER_TICK = 480.0;
    public static int RADIOACTIVEPROCESSOR_REQUIRED_TICKS = 300;
    private final String modID;

    public NuclearScienceRadioactiveProcessorRecipes() {
        this("nuclearscience");
    }

    public NuclearScienceRadioactiveProcessorRecipes(String modID) {
        this.modID = modID;
    }

    public void addRecipes(RecipeOutput output) {
        this.newRecipe(new ItemStack((ItemLike)NuclearScienceItems.ITEM_PLUTONIUMOXIDE.get()), 0.0f, RADIOACTIVEPROCESSOR_REQUIRED_TICKS, RADIOACTIVEPROCESSOR_USAGE_PER_TICK, "plutonium_oxide", this.modID).addItemTagInput(NuclearScienceTags.Items.DUST_FISSILE, 2).addFluidTagInput(VoltaicTags.Fluids.IRON_SULFATE, 3000).save(output);
        this.newRecipe(new ItemStack((ItemLike)NuclearScienceItems.ITEM_THORIANITEDUST.get()), 0.0f, RADIOACTIVEPROCESSOR_REQUIRED_TICKS, RADIOACTIVEPROCESSOR_USAGE_PER_TICK, "thorianite_dust", this.modID).addItemTagInput(VoltaicTags.Items.RAW_ORE_THORIUM, 1).addFluidTagInput(VoltaicTags.Fluids.SULFURIC_ACID, 1000).save(output);
        this.newRecipe(new ItemStack((ItemLike)Items.DIRT), 0.0f, RADIOACTIVEPROCESSOR_REQUIRED_TICKS, RADIOACTIVEPROCESSOR_USAGE_PER_TICK, "dirt_from_irradiated_soil", this.modID).addItemStackInput(new ItemStack((ItemLike)NuclearScienceBlocks.BLOCKS_IRRADIATED.getValue((Object)SubtypeIrradiatedBlock.soil))).addFluidTagInput(FluidTags.WATER, 100).save(output);
        this.newRecipe(new ItemStack((ItemLike)Items.COAL), 0.0f, RADIOACTIVEPROCESSOR_REQUIRED_TICKS, RADIOACTIVEPROCESSOR_USAGE_PER_TICK, "coal_from_petrified_wood", this.modID).addItemStackInput(new ItemStack((ItemLike)NuclearScienceBlocks.BLOCKS_IRRADIATED.getValue((Object)SubtypeIrradiatedBlock.petrifiedwood))).addFluidTagInput(FluidTags.WATER, 100).save(output);
        this.newRecipe(new ItemStack((ItemLike)NuclearScienceItems.ITEM_ACTINIUM225.get()), 0.0f, RADIOACTIVEPROCESSOR_REQUIRED_TICKS, RADIOACTIVEPROCESSOR_USAGE_PER_TICK, "actinium225", this.modID).addItemTagInput(NuclearScienceTags.Items.OXIDE_ACTINIUM, 1).addFluidTagInput(VoltaicTags.Fluids.HYDROFLUORIC_ACID, 100).save(output);
    }

    public FluidItem2ItemBuilder<RadioactiveProcessorRecipe> newRecipe(ItemStack stack, float xp, int ticks, double usagePerTick, String name, String group) {
        return new FluidItem2ItemBuilder(RadioactiveProcessorRecipe::new, stack, BaseRecipeBuilder.RecipeCategory.FLUID_ITEM_2_ITEM, this.modID, "radioactive_processor/" + name, group, (double)xp, ticks, usagePerTick);
    }
}

