/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.prefab.screen.component.quantumtunnel;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.common.inventory.container.ContainerQuantumTunnel;
import nuclearscience.common.tile.TileQuantumTunnel;
import nuclearscience.prefab.screen.component.quantumtunnel.QuantumTunnelTextures;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.utilities.math.Color;

public class ButtonTunnelFrequency
extends ScreenComponentButton<ButtonTunnelFrequency> {
    private TunnelFrequency frequency = null;
    private boolean isSelected = false;

    public ButtonTunnelFrequency(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (!this.isVisible()) {
            return;
        }
        GenericScreen screen = (GenericScreen)this.gui;
        TileQuantumTunnel tile = (TileQuantumTunnel)((ContainerQuantumTunnel)screen.getMenu()).getSafeHost();
        if (tile == null) {
            return;
        }
        QuantumTunnelTextures texture = this.frequency != null && (((TunnelFrequency)tile.frequency.getValue()).equals(this.frequency) || this.isSelected || this.isHovered()) ? QuantumTunnelTextures.FREQUENCY_SELECTED : QuantumTunnelTextures.FREQUENCY;
        ScreenComponentEditBox.drawExpandedBox((GuiGraphics)graphics, (ResourceLocation)texture.getLocation(), (int)(this.xLocation + guiWidth), (int)(this.yLocation + guiHeight), (int)this.width, (int)this.height);
        if (this.frequency == null) {
            return;
        }
        graphics.drawString(screen.getFontRenderer(), (Component)Component.literal((String)this.frequency.getName()), guiWidth + this.xLocation + 5, guiHeight + this.yLocation + 5, Color.WHITE.color(), false);
        Player player = tile.getLevel().getPlayerByUUID(this.frequency.getCreatorId());
        graphics.drawString(screen.getFontRenderer(), (Component)(player != null ? player.getName() : Component.literal((String)this.frequency.getCreatorFallbackName())), guiWidth + this.xLocation + 5, guiHeight + this.yLocation + 15, Color.TEXT_GRAY.color(), false);
    }

    public void setFrequency(TunnelFrequency frequency) {
        this.frequency = frequency;
    }

    public TunnelFrequency getFrequency() {
        return this.frequency;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }
}

