/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.registers;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.api.quantumtunnel.TunnelFrequencyBuffer;
import nuclearscience.common.settings.NuclearConfig;

public class NuclearScienceAttachmentTypes {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"nuclearscience");
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<HashMap<UUID, HashSet<TunnelFrequency>>>> CHANNEL_MAP = ATTACHMENT_TYPES.register("channelmap", () -> AttachmentType.builder(() -> new HashMap()).serialize((IAttachmentSerializer)new IAttachmentSerializer<CompoundTag, HashMap<UUID, HashSet<TunnelFrequency>>>(){

        public HashMap<UUID, HashSet<TunnelFrequency>> read(IAttachmentHolder holder, CompoundTag tag, HolderLookup.Provider provider) {
            HashMap<UUID, HashSet<TunnelFrequency>> data = new HashMap<UUID, HashSet<TunnelFrequency>>();
            int size = tag.getInt("size");
            for (int i = 0; i < size; ++i) {
                CompoundTag stored = tag.getCompound("" + i);
                UUID id = (UUID)UUIDUtil.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)stored.get("id"))).result().get();
                HashSet<TunnelFrequency> set = new HashSet<TunnelFrequency>();
                for (int j = 0; j < stored.getInt("setsize"); ++j) {
                    set.add((TunnelFrequency)TunnelFrequency.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)stored.get("" + j))).result().get());
                }
                data.put(id, set);
            }
            return data;
        }

        @Nullable
        public CompoundTag write(HashMap<UUID, HashSet<TunnelFrequency>> attachment, HolderLookup.Provider provider) {
            CompoundTag data = new CompoundTag();
            int size = attachment.size();
            data.putInt("size", size);
            int i = 0;
            for (Map.Entry<UUID, HashSet<TunnelFrequency>> entry : attachment.entrySet()) {
                CompoundTag store = new CompoundTag();
                UUIDUtil.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)entry.getKey()).ifSuccess(tag -> store.put("id", tag));
                store.putInt("setsize", entry.getValue().size());
                int j = 0;
                for (TunnelFrequency freq : entry.getValue()) {
                    int finalJ = j++;
                    TunnelFrequency.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)freq).ifSuccess(tag -> store.put("" + finalJ, tag));
                }
                data.put("" + i, (Tag)store);
                ++i;
            }
            return data;
        }
    }).build());
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<HashMap<TunnelFrequency, TunnelFrequencyBuffer>>> TUNNEL_MAP = ATTACHMENT_TYPES.register("tunnelmap", () -> AttachmentType.builder(() -> new HashMap()).serialize((IAttachmentSerializer)new IAttachmentSerializer<CompoundTag, HashMap<TunnelFrequency, TunnelFrequencyBuffer>>(){

        public HashMap<TunnelFrequency, TunnelFrequencyBuffer> read(IAttachmentHolder holder, CompoundTag tag, HolderLookup.Provider provider) {
            HashMap<TunnelFrequency, TunnelFrequencyBuffer> data = new HashMap<TunnelFrequency, TunnelFrequencyBuffer>();
            int size = tag.getInt("size");
            for (int i = 0; i < size; ++i) {
                CompoundTag stored = tag.getCompound("" + i);
                data.put((TunnelFrequency)TunnelFrequency.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)stored.get("id"))).result().get(), (TunnelFrequencyBuffer)TunnelFrequencyBuffer.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)stored.get("buffer"))).result().get());
            }
            return data;
        }

        @Nullable
        public CompoundTag write(HashMap<TunnelFrequency, TunnelFrequencyBuffer> attachment, HolderLookup.Provider provider) {
            CompoundTag data = new CompoundTag();
            int size = attachment.size();
            data.putInt("size", size);
            int i = 0;
            for (Map.Entry<TunnelFrequency, TunnelFrequencyBuffer> entry : attachment.entrySet()) {
                CompoundTag store = new CompoundTag();
                TunnelFrequency.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)entry.getKey()).ifSuccess(tag -> store.put("id", tag));
                TunnelFrequencyBuffer.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)entry.getValue()).ifSuccess(tag -> store.put("buffer", tag));
                data.put("" + i, (Tag)store);
                ++i;
            }
            return data;
        }
    }).build());
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<Integer>> ANTIMATTER_TIMEONGROUND = ATTACHMENT_TYPES.register("timeonground", () -> AttachmentType.builder(() -> (Integer)NuclearConfig.INSTANCE.ANTIMATTER_TICKS_ON_GROUND.get()).serialize((Codec)Codec.INT).build());
}

