/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.api.quantumtunnel;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import nuclearscience.api.quantumtunnel.ICapabilityChannelMap;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.registers.NuclearScienceCapabilities;
import voltaic.prefab.utilities.CodecUtils;

public class CapabilityChannelMap
implements ICapabilityChannelMap,
ICapabilitySerializable<CompoundNBT> {
    private final HashMap<UUID, HashSet<TunnelFrequency>> map = new HashMap();
    private final LazyOptional<ICapabilityChannelMap> lazyOptional = LazyOptional.of(() -> this);

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == NuclearScienceCapabilities.CAPABILITY_CHANNELMAP) {
            return this.lazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT data = new CompoundNBT();
        int size = this.map.size();
        data.func_74768_a("size", size);
        int i = 0;
        for (Map.Entry<UUID, HashSet<TunnelFrequency>> entry : this.map.entrySet()) {
            CompoundNBT store = new CompoundNBT();
            CodecUtils.UUID_CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)entry.getKey()).result().ifPresent(tag -> store.func_218657_a("id", tag));
            store.func_74768_a("setsize", entry.getValue().size());
            int j = 0;
            for (TunnelFrequency freq : entry.getValue()) {
                int finalJ = j++;
                TunnelFrequency.CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)freq).result().ifPresent(tag -> store.func_218657_a("" + finalJ, tag));
            }
            data.func_218657_a(i + "", (INBT)store);
            ++i;
        }
        return data;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (NuclearScienceCapabilities.CAPABILITY_CHANNELMAP == null) {
            return;
        }
        this.map.clear();
        int size = nbt.func_74762_e("size");
        for (int i = 0; i < size; ++i) {
            CompoundNBT stored = nbt.func_74775_l("" + i);
            Optional id = CodecUtils.UUID_CODEC.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)stored.func_74781_a("id")).result();
            if (!id.isPresent()) continue;
            HashSet set = new HashSet();
            for (int j = 0; j < stored.func_74762_e("setsize"); ++j) {
                TunnelFrequency.CODEC.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)stored.func_74781_a("" + j)).result().ifPresent(pair -> set.add(pair.getFirst()));
            }
            this.map.put((UUID)((Pair)id.get()).getFirst(), set);
        }
    }

    @Override
    public HashMap<UUID, HashSet<TunnelFrequency>> getMap() {
        return this.map;
    }

    @Override
    public CompoundNBT toTag() {
        return this.serializeNBT();
    }

    @Override
    public void fromTag(CompoundNBT tag) {
        this.deserializeNBT(tag);
    }
}

