/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.api.quantumtunnel;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import nuclearscience.api.quantumtunnel.ICapabilityTunnelMap;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.api.quantumtunnel.TunnelFrequencyBuffer;
import nuclearscience.registers.NuclearScienceCapabilities;

public class CapabilityTunnelMap
implements ICapabilityTunnelMap,
ICapabilitySerializable<CompoundNBT> {
    private final HashMap<TunnelFrequency, TunnelFrequencyBuffer> map = new HashMap();
    private final LazyOptional<ICapabilityTunnelMap> lazyOptional = LazyOptional.of(() -> this);

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == NuclearScienceCapabilities.CAPABILITY_TUNNELMAP) {
            return this.lazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT data = new CompoundNBT();
        int size = this.map.size();
        data.func_74768_a("size", size);
        int i = 0;
        for (Map.Entry<TunnelFrequency, TunnelFrequencyBuffer> entry : this.map.entrySet()) {
            CompoundNBT store = new CompoundNBT();
            TunnelFrequency.CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)entry.getKey()).result().ifPresent(tag -> store.func_218657_a("id", tag));
            TunnelFrequencyBuffer.CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)entry.getValue()).result().ifPresent(tag -> store.func_218657_a("buffer", tag));
            data.func_218657_a(i + "", (INBT)store);
            ++i;
        }
        return data;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (NuclearScienceCapabilities.CAPABILITY_TUNNELMAP == null) {
            return;
        }
        this.map.clear();
        int size = nbt.func_74762_e("size");
        for (int i = 0; i < size; ++i) {
            CompoundNBT stored = nbt.func_74775_l("" + i);
            Optional freq = TunnelFrequency.CODEC.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)stored.func_74781_a("id")).result();
            Optional val = TunnelFrequencyBuffer.CODEC.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)stored.func_74775_l("buffer")).result();
            if (!freq.isPresent() || !val.isPresent()) continue;
            this.map.put((TunnelFrequency)((Pair)freq.get()).getFirst(), (TunnelFrequencyBuffer)((Pair)val.get()).getFirst());
        }
    }

    @Override
    public HashMap<TunnelFrequency, TunnelFrequencyBuffer> getMap() {
        return this.map;
    }

    @Override
    public CompoundNBT toTag() {
        return this.serializeNBT();
    }

    @Override
    public void fromTag(CompoundNBT tag) {
        this.deserializeNBT(tag);
    }
}

