/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.api.quantumtunnel;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import voltaic.api.codec.StreamCodec;
import voltaic.prefab.utilities.object.TransferPack;

public class TunnelFrequencyBuffer {
    public static final Codec<TunnelFrequencyBuffer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TransferPack.CODEC.fieldOf("energy").forGetter(TunnelFrequencyBuffer::getBufferedEnergy), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(TunnelFrequencyBuffer::getBufferedFluid), (App)ItemStack.field_234691_a_.fieldOf("item").forGetter(TunnelFrequencyBuffer::getBufferedItem)).apply((Applicative)instance, TunnelFrequencyBuffer::new));
    public static final StreamCodec<PacketBuffer, TunnelFrequencyBuffer> STREAM_CODEC = new StreamCodec<PacketBuffer, TunnelFrequencyBuffer>(){

        public void encode(PacketBuffer buffer, TunnelFrequencyBuffer value) {
            TransferPack.STREAM_CODEC.encode((Object)buffer, (Object)value.energyBuffer);
            StreamCodec.FLUID_STACK.encode((Object)buffer, (Object)value.fluidBuffer);
            StreamCodec.ITEM_STACK.encode((Object)buffer, (Object)value.itemBuffer);
        }

        public TunnelFrequencyBuffer decode(PacketBuffer buffer) {
            return new TunnelFrequencyBuffer((TransferPack)TransferPack.STREAM_CODEC.decode((Object)buffer), (FluidStack)StreamCodec.FLUID_STACK.decode((Object)buffer), (ItemStack)StreamCodec.ITEM_STACK.decode((Object)buffer));
        }
    };
    public static final TunnelFrequencyBuffer EMPTY = new TunnelFrequencyBuffer(TransferPack.EMPTY, FluidStack.EMPTY, ItemStack.field_190927_a);
    public static final double MAX_JOULES_CAP = Double.MAX_VALUE;
    public static final int MAX_FLUID_CAP = Integer.MAX_VALUE;
    public static final int MAX_GAS_CAP = Integer.MAX_VALUE;
    public static final int MAX_ITEM_STACK_SIZE = 1000;
    private TransferPack energyBuffer = TransferPack.EMPTY;
    private FluidStack fluidBuffer = FluidStack.EMPTY;
    private ItemStack itemBuffer = ItemStack.field_190927_a;

    private TunnelFrequencyBuffer(TransferPack energy, FluidStack fluid, ItemStack item) {
        this.energyBuffer = energy;
        this.fluidBuffer = fluid;
        this.itemBuffer = item;
    }

    public TunnelFrequencyBuffer() {
    }

    public TransferPack getBufferedEnergy() {
        return this.energyBuffer;
    }

    public FluidStack getBufferedFluid() {
        return this.fluidBuffer;
    }

    public ItemStack getBufferedItem() {
        return this.itemBuffer;
    }

    public TransferPack addEnergy(boolean simulate, TransferPack addition) {
        if (addition.getJoules() <= 0.0) {
            return TransferPack.EMPTY;
        }
        if (this.energyBuffer.getVoltage() <= 0.0 && this.energyBuffer.getJoules() <= 0.0) {
            TransferPack check = addition;
            if (check.getJoules() - Double.MAX_VALUE > 0.0) {
                check = TransferPack.joulesVoltage((double)Double.MAX_VALUE, (double)addition.getVoltage());
            }
            if (!simulate) {
                this.energyBuffer = TransferPack.joulesVoltage((double)check.getJoules(), (double)check.getVoltage());
            }
            return check;
        }
        if (this.energyBuffer.getVoltage() != 0.0 && this.energyBuffer.getVoltage() != addition.getVoltage()) {
            return TransferPack.EMPTY;
        }
        double accepted = Math.min(Double.MAX_VALUE - this.energyBuffer.getJoules(), addition.getJoules());
        if (!simulate) {
            this.energyBuffer = TransferPack.joulesVoltage((double)(this.energyBuffer.getJoules() + accepted), (double)this.energyBuffer.getVoltage());
        }
        return TransferPack.joulesVoltage((double)accepted, (double)addition.getVoltage());
    }

    public TransferPack extractEnergy(boolean simulate, TransferPack extract) {
        if (this.energyBuffer.getJoules() <= 0.0 || this.energyBuffer.getVoltage() <= 0.0 || extract.getVoltage() <= 0.0 || extract.getJoules() <= 0.0 || this.energyBuffer.getVoltage() != extract.getVoltage()) {
            return TransferPack.EMPTY;
        }
        double taken = Math.min(extract.getJoules(), this.energyBuffer.getJoules());
        if (!simulate) {
            this.energyBuffer = taken >= this.energyBuffer.getJoules() ? TransferPack.EMPTY : TransferPack.joulesVoltage((double)(this.energyBuffer.getJoules() - taken), (double)this.energyBuffer.getVoltage());
        }
        return TransferPack.joulesVoltage((double)taken, (double)extract.getVoltage());
    }

    public FluidStack addFluid(IFluidHandler.FluidAction action, FluidStack addition) {
        if (addition.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (this.fluidBuffer.isEmpty()) {
            FluidStack check = addition;
            if (check.getAmount() - Integer.MAX_VALUE > 0) {
                check = new FluidStack(addition.getFluid(), Integer.MAX_VALUE);
            }
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.fluidBuffer = check.copy();
            }
            return check;
        }
        if (this.fluidBuffer.getAmount() != 0 && !this.fluidBuffer.getFluid().func_207187_a(addition.getFluid())) {
            return FluidStack.EMPTY;
        }
        int accepted = Math.min(Integer.MAX_VALUE - this.fluidBuffer.getAmount(), addition.getAmount());
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.fluidBuffer = new FluidStack(this.fluidBuffer.getFluid(), this.fluidBuffer.getAmount() + accepted);
        }
        return new FluidStack(addition.getFluid(), accepted);
    }

    public FluidStack extractFluid(IFluidHandler.FluidAction action, FluidStack extract) {
        if (this.fluidBuffer.isEmpty() || extract.isEmpty() || !this.fluidBuffer.getFluid().func_207187_a(extract.getFluid())) {
            return FluidStack.EMPTY;
        }
        int taken = Math.min(extract.getAmount(), this.fluidBuffer.getAmount());
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.fluidBuffer = taken >= this.fluidBuffer.getAmount() ? FluidStack.EMPTY : new FluidStack(this.fluidBuffer.getFluid(), this.fluidBuffer.getAmount() - taken);
        }
        return new FluidStack(extract.getFluid(), taken);
    }

    public ItemStack addItem(boolean simulate, ItemStack addition) {
        if (addition.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.itemBuffer.func_190926_b()) {
            ItemStack check = addition;
            if (check.func_190916_E() - 1000 > 0) {
                check = addition.func_77946_l();
                check.func_190920_e(1000);
            }
            if (!simulate) {
                this.itemBuffer = check.func_77946_l();
            }
            return check;
        }
        if (this.itemBuffer.func_190916_E() > 0 && addition.func_77973_b() != this.itemBuffer.func_77973_b()) {
            return ItemStack.field_190927_a;
        }
        int accepted = Math.min(1000 - this.itemBuffer.func_190916_E(), addition.func_190916_E());
        if (!simulate) {
            this.itemBuffer.func_190920_e(accepted + this.itemBuffer.func_190916_E());
        }
        ItemStack returned = addition.func_77946_l();
        returned.func_190920_e(accepted);
        return returned;
    }

    public ItemStack extractItem(boolean simulate, ItemStack extract) {
        if (this.itemBuffer.func_190926_b() || extract.func_190926_b() || extract.func_77973_b() != this.itemBuffer.func_77973_b()) {
            return ItemStack.field_190927_a;
        }
        int taken = Math.min(extract.func_190916_E(), this.itemBuffer.func_190916_E());
        if (!simulate) {
            if (taken >= this.itemBuffer.func_190916_E()) {
                this.itemBuffer = ItemStack.field_190927_a;
            } else {
                this.itemBuffer.func_190920_e(taken);
            }
        }
        ItemStack returned = extract.func_77946_l();
        returned.func_190920_e(taken);
        return returned;
    }
}

