/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import nuclearscience.common.tile.TileChemicalExtractor;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.utilities.RenderingUtils;

public class RenderChemicalExtractor
extends AbstractTileRenderer<TileChemicalExtractor> {
    private static final float DELTA_Y = 0.4375f;

    public RenderChemicalExtractor(TileEntityRendererDispatcher context) {
        super(context);
    }

    public void render(TileChemicalExtractor tile, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int overlay) {
        matrix.func_227860_a_();
        Direction facing = tile.getFacing();
        ComponentFluidHandlerMulti multi = (ComponentFluidHandlerMulti)tile.getComponent(IComponentType.FluidHandler);
        IVertexBuilder builder = buffer.getBuffer(Atlases.func_228785_j_());
        PropertyFluidTank input = multi.getInputTanks()[0];
        if (input.isEmpty()) {
            matrix.func_227865_b_();
            return;
        }
        AxisAlignedBB box = null;
        int i = 0;
        float maxY = 0.4375f * ((float)input.getFluidAmount() / 5000.0f) + 0.3125f;
        if (facing == Direction.NORTH || facing != Direction.EAST && facing == Direction.SOUTH) {
            box = new AxisAlignedBB(0.16875, 0.3125, 0.1375, 0.26875, (double)maxY, 0.2375);
            for (i = 0; i < 4; ++i) {
                RenderingUtils.renderFluidBox((MatrixStack)matrix, (Minecraft)this.minecraft(), (IVertexBuilder)builder, (AxisAlignedBB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                box = box.func_72317_d(0.1875, 0.0, 0.0);
            }
            box = new AxisAlignedBB(0.16875, 0.3125, 0.7625, 0.26875, (double)maxY, 0.8625);
            for (i = 0; i < 4; ++i) {
                RenderingUtils.renderFluidBox((MatrixStack)matrix, (Minecraft)this.minecraft(), (IVertexBuilder)builder, (AxisAlignedBB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                box = box.func_72317_d(0.1875, 0.0, 0.0);
            }
        } else {
            box = new AxisAlignedBB(0.1375, 0.3125, 0.16875, 0.2375, (double)maxY, 0.26875);
            for (i = 0; i < 4; ++i) {
                RenderingUtils.renderFluidBox((MatrixStack)matrix, (Minecraft)this.minecraft(), (IVertexBuilder)builder, (AxisAlignedBB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                box = box.func_72317_d(0.0, 0.0, 0.1875);
            }
            box = new AxisAlignedBB(0.7625, 0.3125, 0.16875, 0.8625, (double)maxY, 0.26875);
            for (i = 0; i < 4; ++i) {
                RenderingUtils.renderFluidBox((MatrixStack)matrix, (Minecraft)this.minecraft(), (IVertexBuilder)builder, (AxisAlignedBB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                box = box.func_72317_d(0.0, 0.0, 0.1875);
            }
        }
        matrix.func_227865_b_();
    }
}

