/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import nuclearscience.client.NuclearScienceClientRegister;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileControlRodModule;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.Color;

public class RenderControlRodModule
extends AbstractTileRenderer<TileControlRodModule> {
    private static final double MAX_DELTA = 0.8125;

    public RenderControlRodModule(TileEntityRendererDispatcher context) {
        super(context);
    }

    public void render(@Nonnull TileControlRodModule tile, float partialTicks, MatrixStack stack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        stack.func_227860_a_();
        stack.func_227861_a_(0.5, 0.5, 0.5);
        Direction facing = tile.getFacing();
        int sign = 1;
        if (facing == Direction.WEST || facing == Direction.EAST) {
            sign = -1;
        }
        stack.func_227863_a_(new Quaternion(0.0f, facing.func_185119_l() - (float)(sign * 90), 0.0f, true));
        double insertion = (double)((Integer)tile.insertion.getValue()).intValue() / 100.0;
        stack.func_227861_a_(0.0, 0.0, -0.8125 * insertion);
        RenderingUtils.renderModel((IBakedModel)this.getModel(NuclearScienceClientRegister.MODEL_CONTROLRODMODULE_ROD), (TileEntity)tile, (RenderType)RenderType.func_228639_c_(), (MatrixStack)stack, (IRenderTypeBuffer)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        stack.func_227865_b_();
        if (!((Boolean)tile.linked.getValue()).booleanValue()) {
            return;
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        stack.func_227860_a_();
        stack.func_227861_a_(0.5, 0.5, 0.5);
        this.rotateMatrix(stack, facing);
        stack.func_227861_a_(0.0, 0.175, 0.1775);
        IFormattableTextComponent transfer = ChatFormatter.getChatDisplayShort((double)((double)((Integer)tile.insertion.getValue()).intValue() / 100.0 * 100.0), (IDisplayUnit)DisplayUnits.PERCENTAGE);
        float scale = 0.0215f / ((float)font.func_238414_a_((ITextProperties)transfer) / 16.0f);
        stack.func_227862_a_(-scale, -scale, -scale);
        Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
        float textX = (float)(-font.func_238414_a_((ITextProperties)transfer)) / 2.0f;
        font.func_243247_a((ITextComponent)transfer, textX, 0.0f, Color.WHITE.color(), false, matrix4f, bufferIn, false, 0, combinedLightIn);
        stack.func_227865_b_();
    }

    private void rotateMatrix(MatrixStack stack, Direction dir) {
        switch (dir) {
            case EAST: {
                stack.func_227863_a_(new Quaternion(0.0f, -90.0f, 0.0f, true));
                return;
            }
            case SOUTH: {
                stack.func_227863_a_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                return;
            }
            case WEST: {
                stack.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                return;
            }
        }
    }
}

