/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import nuclearscience.client.NuclearScienceClientRegister;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.Color;

public class RenderFissionReactorCore
extends AbstractTileRenderer<TileFissionReactorCore> {
    public static final AxisAlignedBB FUEL_ROD_1 = new AxisAlignedBB(0.1875, 0.1125, 0.1875, 0.25, 0.75, 0.25);
    public static final AxisAlignedBB FUEL_ROD_2 = new AxisAlignedBB(0.75, 0.1125, 0.1875, 0.8125, 0.75, 0.25);
    public static final AxisAlignedBB FUEL_ROD_3 = new AxisAlignedBB(0.75, 0.1125, 0.75, 0.8125, 0.75, 0.8125);
    public static final AxisAlignedBB FUEL_ROD_4 = new AxisAlignedBB(0.1875, 0.1125, 0.75, 0.25, 0.75, 0.8125);
    public static final AxisAlignedBB TRITIUM_CELL = new AxisAlignedBB(0.4375, 0.1125, 0.4375, 0.5625, 0.75, 0.5625);
    public static final Color HIGH_ENRICH = new Color(75, 181, 0, 255);
    public static final Color LOW_ENRICH = new Color(40, 98, 0, 255);
    public static final Color SPENT = new Color(116, 147, 95, 255);
    public static final Color PLUTONIUM = new Color(227, 125, 11, 255);
    public static final Color DEUTERIUM = new Color(0, 144, 255, 255);
    public static final Color TRITIUM = new Color(255, 255, 0, 255);
    public static final boolean[] FACES = new boolean[]{false, false, true, true, true, true};

    public RenderFissionReactorCore(TileEntityRendererDispatcher context) {
        super(context);
    }

    public void render(TileFissionReactorCore tile, float partialTicks, MatrixStack matrix, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrix.func_227860_a_();
        ComponentInventory inv = (ComponentInventory)tile.getComponent(IComponentType.Inventory);
        if (!inv.areInputsEmpty()) {
            List inputs = inv.getInputContents();
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = (ItemStack)inputs.get(i);
                if (stack.func_190926_b()) continue;
                this.renderFuelCell(i, stack, matrix, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            if (!((ItemStack)inputs.get(4)).func_190926_b()) {
                this.renderDeuteriumCell(DEUTERIUM, matrix, bufferIn, combinedLightIn, combinedOverlayIn);
            } else if (!((ItemStack)inv.getOutputContents().get(0)).func_190926_b()) {
                this.renderDeuteriumCell(TRITIUM, matrix, bufferIn, combinedLightIn, combinedOverlayIn);
            }
        }
        matrix.func_227865_b_();
    }

    private void renderDeuteriumCell(Color color, MatrixStack matrix, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrix.func_227860_a_();
        TextureAtlasSprite texture = NuclearScienceClientRegister.getSprite(NuclearScienceClientRegister.TEXTURE_FUELCELL);
        RenderingUtils.renderFilledBoxNoOverlay((MatrixStack)matrix, (IVertexBuilder)bufferIn.getBuffer(RenderType.func_228639_c_()), (AxisAlignedBB)TRITIUM_CELL, (float)color.rFloat(), (float)color.gFloat(), (float)color.bFloat(), (float)color.aFloat(), (float)texture.func_94209_e(), (float)texture.func_94206_g(), (float)texture.func_94212_f(), (float)texture.func_94210_h(), (int)combinedLightIn, (boolean[])FACES);
        matrix.func_227865_b_();
    }

    private void renderFuelCell(int cellSlot, ItemStack stack, MatrixStack matrix, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        TextureAtlasSprite texture = NuclearScienceClientRegister.getSprite(NuclearScienceClientRegister.TEXTURE_FUELCELL);
        matrix.func_227860_a_();
        Color color = RenderFissionReactorCore.getColorFromFuel(stack);
        AxisAlignedBB box = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        switch (cellSlot) {
            case 0: {
                box = FUEL_ROD_1;
                break;
            }
            case 1: {
                box = FUEL_ROD_2;
                break;
            }
            case 2: {
                box = FUEL_ROD_3;
                break;
            }
            case 3: {
                box = FUEL_ROD_4;
                break;
            }
        }
        RenderingUtils.renderFilledBoxNoOverlay((MatrixStack)matrix, (IVertexBuilder)bufferIn.getBuffer(RenderType.func_228639_c_()), (AxisAlignedBB)box, (float)color.rFloat(), (float)color.gFloat(), (float)color.bFloat(), (float)color.aFloat(), (float)texture.func_94209_e(), (float)texture.func_94206_g(), (float)texture.func_94212_f(), (float)texture.func_94210_h(), (int)combinedLightIn, (boolean[])FACES);
        matrix.func_227865_b_();
    }

    public static Color getColorFromFuel(ItemStack stack) {
        if (stack.func_77973_b() == NuclearScienceTags.Items.FUELROD_URANIUM_LOW_EN) {
            return LOW_ENRICH;
        }
        if (stack.func_77973_b() == NuclearScienceTags.Items.FUELROD_URANIUM_HIGH_EN) {
            return HIGH_ENRICH;
        }
        if (stack.func_77973_b() == NuclearScienceTags.Items.FUELROD_PLUTONIUM) {
            return PLUTONIUM;
        }
        if (stack.func_77973_b() == NuclearScienceTags.Items.FUELROD_SPENT) {
            return SPENT;
        }
        return Color.WHITE;
    }
}

